/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.remote.AssociationImpl;
import org.jboss.as.ejb3.remote.RegistryCollector;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.ListenerHandle;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceRegistration;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.LocalRegistryAndDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.RegistryProvider;

public final class AssociationService
implements Service<AssociationService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "association"});
    private final InjectedValue<DeploymentRepository> deploymentRepositoryInjector = new InjectedValue();
    private final InjectedValue<RegistryCollector> registryCollectorInjector = new InjectedValue();
    private final InjectedValue<SuspendController> suspendControllerInjector = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironmentServiceInjector = new InjectedValue();
    private final LocalRegistryAndDiscoveryProvider localRegistry = new LocalRegistryAndDiscoveryProvider();
    private AssociationImpl value;
    private ListenerHandle handle;
    private ServiceRegistration serviceRegistration;

    public void start(StartContext context) throws StartException {
        this.value = new AssociationImpl((DeploymentRepository)this.deploymentRepositoryInjector.getValue(), (RegistryCollector)this.registryCollectorInjector.getValue());
        ServiceURL.Builder builder = new ServiceURL.Builder();
        builder.setAbstractType("ejb").setAbstractTypeAuthority("jboss");
        builder.setUri(Affinity.LOCAL.getUri());
        builder.addAttribute("node", AttributeValue.fromString((String)((ServerEnvironment)this.serverEnvironmentServiceInjector.getValue()).getNodeName()));
        this.serviceRegistration = this.getLocalRegistryProvider().registerService(builder.create());
        this.handle = this.value.registerModuleAvailabilityListener(new ModuleAvailabilityListener(){
            private final ConcurrentHashMap<ModuleAvailabilityListener.ModuleIdentifier, ServiceRegistration> map = new ConcurrentHashMap();

            public void moduleAvailable(List<ModuleAvailabilityListener.ModuleIdentifier> modules) {
                for (ModuleAvailabilityListener.ModuleIdentifier module : modules) {
                    String appName = module.getAppName();
                    String moduleName = module.getModuleName();
                    String distinctName = module.getDistinctName();
                    ServiceURL.Builder builder = new ServiceURL.Builder();
                    builder.setUri(Affinity.LOCAL.getUri());
                    builder.setAbstractType("ejb");
                    builder.setAbstractTypeAuthority("jboss");
                    if (distinctName.isEmpty()) {
                        if (appName.isEmpty()) {
                            builder.addAttribute("ejb-module", AttributeValue.fromString((String)moduleName));
                        } else {
                            builder.addAttribute("ejb-module", AttributeValue.fromString((String)(appName + "/" + moduleName)));
                        }
                    } else if (appName.isEmpty()) {
                        builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(moduleName + "/" + distinctName)));
                    } else {
                        builder.addAttribute("ejb-module-distinct", AttributeValue.fromString((String)(appName + "/" + moduleName + "/" + distinctName)));
                    }
                    ServiceRegistration serviceRegistration = AssociationService.this.localRegistry.registerService(builder.create());
                    this.map.putIfAbsent(module, serviceRegistration);
                }
            }

            public void moduleUnavailable(List<ModuleAvailabilityListener.ModuleIdentifier> modules) {
                for (ModuleAvailabilityListener.ModuleIdentifier module : modules) {
                    this.map.computeIfPresent(module, (i, old) -> {
                        old.close();
                        return null;
                    });
                }
            }
        });
    }

    public void stop(StopContext context) {
        this.value = null;
        this.handle.close();
        this.serviceRegistration.close();
        this.handle = null;
        this.serviceRegistration = null;
    }

    public AssociationService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ServerEnvironment> getServerEnvironmentServiceInjector() {
        return this.serverEnvironmentServiceInjector;
    }

    public InjectedValue<DeploymentRepository> getDeploymentRepositoryInjector() {
        return this.deploymentRepositoryInjector;
    }

    public InjectedValue<RegistryCollector> getRegistryCollectorInjector() {
        return this.registryCollectorInjector;
    }

    public InjectedValue<SuspendController> getSuspendControllerInjector() {
        return this.suspendControllerInjector;
    }

    public RegistryProvider getLocalRegistryProvider() {
        return this.localRegistry;
    }

    public DiscoveryProvider getLocalDiscoveryProvider() {
        return this.localRegistry;
    }

    public Association getAssociation() {
        return this.value;
    }

    void setExecutor(Executor executor) {
        if (this.value != null) {
            this.value.setExecutor(executor);
        }
    }
}

