/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.TimeUnitValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfig;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfigService;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolAdd;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolWriteHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class StrictMaxPoolResourceDefinition
extends SimpleResourceDefinition {
    public static final StrictMaxPoolResourceDefinition INSTANCE = new StrictMaxPoolResourceDefinition();
    public static final SimpleAttributeDefinition MAX_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-pool-size", ModelType.INT, true).setDefaultValue(new ModelNode().set(20))).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, true, true))).setAlternatives(new String[]{"derive-size"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
    public static final SimpleAttributeDefinition DERIVE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("derive-size", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)EnumValidator.create(DeriveSize.class, (boolean)true, (boolean)false, (Enum[])DeriveSize.access$000()))).setCorrector((newValue, currentValue) -> newValue.getType() == ModelType.STRING && DeriveSize.NONE.toString().equalsIgnoreCase(newValue.asString()) ? new ModelNode() : newValue)).setAlternatives(new String[]{"max-pool-size"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
    public static final SimpleAttributeDefinition INSTANCE_ACQUISITION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout", ModelType.LONG, true).setXmlName(EJB3SubsystemXMLAttribute.INSTANCE_ACQUISITION_TIMEOUT.getLocalName())).setDefaultValue(new ModelNode().set(5L))).setAllowExpression(true)).setValidator((ParameterValidator)new LongRangeValidator(1L, Integer.MAX_VALUE, true, true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
    public static final SimpleAttributeDefinition INSTANCE_ACQUISITION_TIMEOUT_UNIT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout-unit", ModelType.STRING, true).setXmlName(EJB3SubsystemXMLAttribute.INSTANCE_ACQUISITION_TIMEOUT_UNIT.getLocalName())).setValidator((ParameterValidator)new TimeUnitValidator(true, true))).setDefaultValue(new ModelNode().set(StrictMaxPoolConfig.DEFAULT_TIMEOUT_UNIT.name()))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).setAllowExpression(true)).build();
    public static final Map<String, AttributeDefinition> ATTRIBUTES;
    private static final String NONE_VALUE = "none";
    private static final String FROM_WORKER_POOLS_VALUE = "from-worker-pools";
    private static final String FROM_CPU_COUNT_VALUE = "from-cpu-count";

    static StrictMaxPoolConfigService.Derive parseDeriveSize(OperationContext context, ModelNode strictMaxPoolModel) throws OperationFailedException {
        ModelNode dsNode = DERIVE_SIZE.resolveModelAttribute(context, strictMaxPoolModel);
        if (dsNode.isDefined()) {
            DeriveSize deriveSize = DeriveSize.fromValue(dsNode.asString());
            switch (deriveSize) {
                case FROM_WORKER_POOLS: {
                    return StrictMaxPoolConfigService.Derive.FROM_WORKER_POOLS;
                }
                case FROM_CPU_COUNT: {
                    return StrictMaxPoolConfigService.Derive.FROM_CPU_COUNT;
                }
            }
        }
        return StrictMaxPoolConfigService.Derive.NONE;
    }

    private StrictMaxPoolResourceDefinition() {
        super(PathElement.pathElement((String)"strict-max-bean-instance-pool"), EJB3Extension.getResourceDescriptionResolver("strict-max-bean-instance-pool"), (OperationStepHandler)StrictMaxPoolAdd.INSTANCE, (OperationStepHandler)new ServiceRemoveStepHandler(StrictMaxPoolConfigService.EJB_POOL_CONFIG_BASE_SERVICE_NAME, (AbstractAddStepHandler)StrictMaxPoolAdd.INSTANCE), OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        Collection<AttributeDefinition> ads = ATTRIBUTES.values();
        StrictMaxPoolWriteHandler osh = new StrictMaxPoolWriteHandler(ads);
        for (AttributeDefinition attr : ads) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)osh);
        }
    }

    static void registerTransformers_1_1_0(ResourceTransformationDescriptionBuilder parent) {
        parent.addChildResource(INSTANCE.getPathElement()).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{INSTANCE_ACQUISITION_TIMEOUT_UNIT});
    }

    static void registerTransformers_1_2_0_and_1_3_0(ResourceTransformationDescriptionBuilder parent) {
        ((AttributeTransformationDescriptionBuilder)parent.addChildResource(INSTANCE.getPathElement()).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(DeriveSize.NONE.toString())}), new AttributeDefinition[]{DERIVE_SIZE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{DERIVE_SIZE});
    }

    static void registerTransformers_3_0_0(ResourceTransformationDescriptionBuilder parent) {
        ((AttributeTransformationDescriptionBuilder)parent.addChildResource(INSTANCE.getPathElement()).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(DeriveSize.NONE.toString())}), new AttributeDefinition[]{DERIVE_SIZE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{DERIVE_SIZE});
    }

    static {
        LinkedHashMap<String, SimpleAttributeDefinition> map = new LinkedHashMap<String, SimpleAttributeDefinition>();
        map.put(MAX_POOL_SIZE.getName(), MAX_POOL_SIZE);
        map.put(DERIVE_SIZE.getName(), DERIVE_SIZE);
        map.put(INSTANCE_ACQUISITION_TIMEOUT.getName(), INSTANCE_ACQUISITION_TIMEOUT);
        map.put(INSTANCE_ACQUISITION_TIMEOUT_UNIT.getName(), INSTANCE_ACQUISITION_TIMEOUT_UNIT);
        ATTRIBUTES = Collections.unmodifiableMap(map);
    }

    static enum DeriveSize {
        NONE("none"),
        FROM_WORKER_POOLS("from-worker-pools"),
        FROM_CPU_COUNT("from-cpu-count");

        private static DeriveSize[] LEGAL_VALUES;
        private String value;

        private DeriveSize(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static DeriveSize fromValue(String value) {
            switch (value) {
                case "none": {
                    return NONE;
                }
                case "from-worker-pools": {
                    return FROM_WORKER_POOLS;
                }
                case "from-cpu-count": {
                    return FROM_CPU_COUNT;
                }
            }
            return DeriveSize.valueOf(value);
        }

        static /* synthetic */ DeriveSize[] access$000() {
            return LEGAL_VALUES;
        }

        static {
            LEGAL_VALUES = EnumSet.complementOf(EnumSet.of(NONE)).toArray(new DeriveSize[2]);
        }
    }
}

