/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.util.HelpFormatter;
import org.jboss.as.protocol.StreamUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class CommandHandlerWithHelp
extends CommandHandlerWithArguments {
    private final String filename;
    private final boolean connectionRequired;
    protected ArgumentWithoutValue helpArg = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--help", "-h");

    public CommandHandlerWithHelp(String command) {
        this(command, false);
    }

    public CommandHandlerWithHelp(String command, boolean connectionRequired) {
        if (command == null) {
            throw new IllegalArgumentException("command can't be null");
        }
        this.filename = "help/" + command + ".txt";
        this.connectionRequired = connectionRequired;
        this.helpArg.setExclusive(true);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return !this.connectionRequired || ctx.getModelControllerClient() != null;
    }

    @Override
    public void handle(CommandContext ctx) throws CommandLineException {
        this.recognizeArguments(ctx);
        if (this.helpArg.isPresent(ctx.getParsedCommandLine())) {
            this.printHelp(ctx);
            return;
        }
        if (!this.isAvailable(ctx)) {
            throw new CommandFormatException("The command is not available in the current context (e.g. required subsystems or connection to the controller might be unavailable).");
        }
        this.doHandle(ctx);
    }

    protected void printHelp(CommandContext ctx) throws CommandLineException {
        BufferedReader reader;
        block5: {
            block4: {
                InputStream helpInput = WildFlySecurityManager.getClassLoaderPrivileged(CommandHandlerWithHelp.class).getResourceAsStream(this.filename);
                if (helpInput == null) break block4;
                reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(helpInput, StandardCharsets.UTF_8));
                    HelpFormatter.format(ctx, reader);
                }
                catch (IOException e) {
                    try {
                        throw new CommandFormatException("Failed to read help/help.txt: " + e.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {
                        StreamUtils.safeClose(reader);
                        throw throwable;
                    }
                }
                break block5;
            }
            throw new CommandFormatException("Failed to locate command description " + this.filename);
        }
        StreamUtils.safeClose((Closeable)reader);
    }

    protected abstract void doHandle(CommandContext var1) throws CommandLineException;

    @Override
    public boolean isBatchMode(CommandContext ctx) {
        return false;
    }

    protected void printList(CommandContext ctx, Collection<String> list, boolean l) {
        if (l) {
            for (String item : list) {
                ctx.printLine(item);
            }
        } else {
            ctx.printColumns(list);
        }
    }
}

