/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.renewer;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.cache.CacheUtils;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.provider.AbstractSAMLTokenProvider;
import org.apache.cxf.sts.token.provider.ConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultConditionsProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.realm.RealmProperties;
import org.apache.cxf.sts.token.renewer.TokenRenewer;
import org.apache.cxf.sts.token.renewer.TokenRenewerParameters;
import org.apache.cxf.sts.token.renewer.TokenRenewerResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.builder.SAML1ComponentBuilder;
import org.apache.wss4j.common.saml.builder.SAML2ComponentBuilder;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.saml.DOMSAMLUtil;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.joda.time.DateTime;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLTokenRenewer
extends AbstractSAMLTokenProvider
implements TokenRenewer {
    public static final long DEFAULT_MAX_EXPIRY = 1800L;
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLTokenRenewer.class);
    private boolean signToken = true;
    private ConditionsProvider conditionsProvider = new DefaultConditionsProvider();
    private Map<String, RealmProperties> realmMap = new HashMap<String, RealmProperties>();
    private long maxExpiry = 1800L;
    private boolean verifyProofOfPossession = true;
    private boolean allowRenewalAfterExpiry;

    @Override
    public boolean canHandleToken(ReceivedToken renewTarget) {
        return this.canHandleToken(renewTarget, null);
    }

    @Override
    public boolean canHandleToken(ReceivedToken renewTarget, String realm) {
        if (realm != null && !this.realmMap.containsKey(realm)) {
            return false;
        }
        Object token = renewTarget.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if (("urn:oasis:names:tc:SAML:1.0:assertion".equals(namespace) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(namespace)) && "Assertion".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setVerifyProofOfPossession(boolean verifyProofOfPossession) {
        this.verifyProofOfPossession = verifyProofOfPossession;
    }

    public boolean isAllowRenewalAfterExpiry() {
        return this.allowRenewalAfterExpiry;
    }

    @Override
    public void setAllowRenewalAfterExpiry(boolean allowRenewalAfterExpiry) {
        this.allowRenewalAfterExpiry = allowRenewalAfterExpiry;
    }

    public void setMaxExpiry(long newExpiry) {
        this.maxExpiry = newExpiry;
    }

    public long getMaxExpiry() {
        return this.maxExpiry;
    }

    @Override
    public TokenRenewerResponse renewToken(TokenRenewerParameters tokenParameters) {
        TokenRenewerResponse response = new TokenRenewerResponse();
        ReceivedToken tokenToRenew = tokenParameters.getToken();
        if (tokenToRenew == null || tokenToRenew.getToken() == null || tokenToRenew.getState() != ReceivedToken.STATE.EXPIRED && tokenToRenew.getState() != ReceivedToken.STATE.VALID) {
            LOG.log(Level.WARNING, "The token to renew is null or invalid");
            throw new STSException("The token to renew is null or invalid", STSException.INVALID_REQUEST);
        }
        TokenStore tokenStore = tokenParameters.getTokenStore();
        if (tokenStore == null) {
            LOG.log(Level.FINE, "A cache must be configured to use the SAMLTokenRenewer");
            throw new STSException("Can't renew SAML assertion", STSException.REQUEST_FAILED);
        }
        try {
            SamlAssertionWrapper assertion = new SamlAssertionWrapper((Element)tokenToRenew.getToken());
            byte[] oldSignature = assertion.getSignatureValue();
            int hash = Arrays.hashCode(oldSignature);
            SecurityToken cachedToken = tokenStore.getToken(Integer.toString(hash));
            if (cachedToken == null) {
                LOG.log(Level.FINE, "The token to be renewed must be stored in the cache");
                throw new STSException("Can't renew SAML assertion", STSException.REQUEST_FAILED);
            }
            this.validateAssertion(assertion, tokenToRenew, cachedToken, tokenParameters);
            SamlAssertionWrapper renewedAssertion = new SamlAssertionWrapper(assertion.getSamlObject());
            String oldId = this.createNewId(renewedAssertion);
            tokenStore.remove(oldId);
            tokenStore.remove(Integer.toString(hash));
            this.createNewConditions(renewedAssertion, tokenParameters);
            this.signAssertion(renewedAssertion, tokenParameters);
            Document doc = DOMUtils.createDocument();
            Element token = renewedAssertion.toDOM(doc);
            if (renewedAssertion.getSaml1() != null) {
                token.setIdAttributeNS(null, "AssertionID", true);
            } else {
                token.setIdAttributeNS(null, "ID", true);
            }
            doc.appendChild(token);
            this.storeTokenInCache(tokenStore, renewedAssertion, tokenParameters.getPrincipal(), tokenParameters);
            response.setToken(token);
            response.setTokenId(renewedAssertion.getId());
            DateTime validFrom = null;
            DateTime validTill = null;
            if (renewedAssertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
                validFrom = renewedAssertion.getSaml2().getConditions().getNotBefore();
                validTill = renewedAssertion.getSaml2().getConditions().getNotOnOrAfter();
            } else {
                validFrom = renewedAssertion.getSaml1().getConditions().getNotBefore();
                validTill = renewedAssertion.getSaml1().getConditions().getNotOnOrAfter();
            }
            response.setCreated(validFrom.toDate());
            response.setExpires(validTill.toDate());
            LOG.fine("SAML Token successfully renewed");
            return response;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "", ex);
            throw new STSException("Can't renew SAML assertion", (Throwable)ex, STSException.REQUEST_FAILED);
        }
    }

    public void setConditionsProvider(ConditionsProvider conditionsProvider) {
        this.conditionsProvider = conditionsProvider;
    }

    public ConditionsProvider getConditionsProvider() {
        return this.conditionsProvider;
    }

    public boolean isSignToken() {
        return this.signToken;
    }

    public void setSignToken(boolean signToken) {
        this.signToken = signToken;
    }

    public void setRealmMap(Map<String, ? extends RealmProperties> realms) {
        this.realmMap.clear();
        this.realmMap.putAll(realms);
    }

    public Map<String, RealmProperties> getRealmMap() {
        return Collections.unmodifiableMap(this.realmMap);
    }

    private void validateAssertion(SamlAssertionWrapper assertion, ReceivedToken tokenToRenew, SecurityToken token, TokenRenewerParameters tokenParameters) throws WSSecurityException {
        String appliesToAddress;
        Map props = token.getProperties();
        if (props == null) {
            LOG.log(Level.WARNING, "Error in getting properties from cached token");
            throw new STSException("Error in getting properties from cached token", STSException.REQUEST_FAILED);
        }
        String isAllowRenewal = (String)props.get("org.apache.cxf.sts.token.renewing.allow");
        String isAllowRenewalAfterExpiry = (String)props.get("org.apache.cxf.sts.token.renewing.allow.after.expiry");
        if (isAllowRenewal == null || !Boolean.valueOf(isAllowRenewal).booleanValue()) {
            LOG.log(Level.WARNING, "The token is not allowed to be renewed");
            throw new STSException("The token is not allowed to be renewed", STSException.REQUEST_FAILED);
        }
        if (tokenToRenew.getState() == ReceivedToken.STATE.EXPIRED) {
            if (!this.allowRenewalAfterExpiry || isAllowRenewalAfterExpiry == null || !Boolean.valueOf(isAllowRenewalAfterExpiry).booleanValue()) {
                LOG.log(Level.WARNING, "Renewal after expiry is not allowed");
                throw new STSException("Renewal after expiry is not allowed", STSException.REQUEST_FAILED);
            }
            DateTime expiryDate = this.getExpiryDate(assertion);
            DateTime currentDate = new DateTime();
            if (currentDate.getMillis() - expiryDate.getMillis() > this.maxExpiry * 1000L) {
                LOG.log(Level.WARNING, "The token expired too long ago to be renewed");
                throw new STSException("The token expired too long ago to be renewed", STSException.REQUEST_FAILED);
            }
        }
        ProofOfPossessionValidator popValidator = new ProofOfPossessionValidator();
        if (this.verifyProofOfPossession) {
            STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
            Crypto sigCrypto = stsProperties.getSignatureCrypto();
            CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
            RequestData requestData = new RequestData();
            requestData.setSigVerCrypto(sigCrypto);
            WSSConfig wssConfig = WSSConfig.getNewInstance();
            requestData.setWssConfig(wssConfig);
            requestData.setCallbackHandler(callbackHandler);
            WSDocInfo docInfo = new WSDocInfo(((Element)tokenToRenew.getToken()).getOwnerDocument());
            assertion.parseSubject((SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, docInfo), sigCrypto, callbackHandler);
            SAMLKeyInfo keyInfo = assertion.getSubjectKeyInfo();
            if (keyInfo == null) {
                keyInfo = new SAMLKeyInfo((byte[])null);
            }
            if (!popValidator.checkProofOfPossession(tokenParameters, keyInfo)) {
                throw new STSException("Failed to verify the proof of possession of the key associated with the saml token. No matching key found in the request.", STSException.INVALID_REQUEST);
            }
        }
        if ((appliesToAddress = tokenParameters.getAppliesToAddress()) != null) {
            if (assertion.getSaml1() != null) {
                List restrConditions = assertion.getSaml1().getConditions().getAudienceRestrictionConditions();
                if (!this.matchSaml1AudienceRestriction(appliesToAddress, restrConditions)) {
                    LOG.log(Level.WARNING, "The AppliesTo address does not match the Audience Restriction");
                    throw new STSException("The AppliesTo address does not match the Audience Restriction", STSException.INVALID_REQUEST);
                }
            } else {
                List audienceRestrs = assertion.getSaml2().getConditions().getAudienceRestrictions();
                if (!this.matchSaml2AudienceRestriction(appliesToAddress, audienceRestrs)) {
                    LOG.log(Level.WARNING, "The AppliesTo address does not match the Audience Restriction");
                    throw new STSException("The AppliesTo address does not match the Audience Restriction", STSException.INVALID_REQUEST);
                }
            }
        }
    }

    private boolean matchSaml1AudienceRestriction(String appliesTo, List<AudienceRestrictionCondition> restrConditions) {
        boolean found = false;
        if (restrConditions != null && !restrConditions.isEmpty()) {
            for (AudienceRestrictionCondition restrCondition : restrConditions) {
                if (restrCondition.getAudiences() == null) continue;
                for (org.opensaml.saml.saml1.core.Audience audience : restrCondition.getAudiences()) {
                    if (!appliesTo.equals(audience.getUri())) continue;
                    return true;
                }
            }
        }
        return found;
    }

    private boolean matchSaml2AudienceRestriction(String appliesTo, List<AudienceRestriction> audienceRestrictions) {
        boolean found = false;
        if (audienceRestrictions != null && !audienceRestrictions.isEmpty()) {
            for (AudienceRestriction audienceRestriction : audienceRestrictions) {
                if (audienceRestriction.getAudiences() == null) continue;
                for (Audience audience : audienceRestriction.getAudiences()) {
                    if (!appliesTo.equals(audience.getAudienceURI())) continue;
                    return true;
                }
            }
        }
        return found;
    }

    private void signAssertion(SamlAssertionWrapper assertion, TokenRenewerParameters tokenParameters) throws Exception {
        if (this.signToken) {
            STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
            String realm = tokenParameters.getRealm();
            RealmProperties samlRealm = null;
            if (realm != null && this.realmMap.containsKey(realm)) {
                samlRealm = this.realmMap.get(realm);
            }
            this.signToken(assertion, samlRealm, stsProperties, tokenParameters.getKeyRequirements());
        } else if (assertion.getSaml1().getSignature() != null) {
            assertion.getSaml1().setSignature(null);
        } else if (assertion.getSaml2().getSignature() != null) {
            assertion.getSaml2().setSignature(null);
        }
    }

    private void createNewConditions(SamlAssertionWrapper assertion, TokenRenewerParameters tokenParameters) {
        ConditionsBean conditions = this.conditionsProvider.getConditions(this.convertToProviderParameters(tokenParameters));
        if (assertion.getSaml1() != null) {
            Assertion saml1Assertion = assertion.getSaml1();
            saml1Assertion.setIssueInstant(new DateTime());
            Conditions saml1Conditions = SAML1ComponentBuilder.createSamlv1Conditions((ConditionsBean)conditions);
            saml1Assertion.setConditions(saml1Conditions);
        } else {
            org.opensaml.saml.saml2.core.Assertion saml2Assertion = assertion.getSaml2();
            saml2Assertion.setIssueInstant(new DateTime());
            org.opensaml.saml.saml2.core.Conditions saml2Conditions = SAML2ComponentBuilder.createConditions((ConditionsBean)conditions);
            saml2Assertion.setConditions(saml2Conditions);
        }
    }

    private TokenProviderParameters convertToProviderParameters(TokenRenewerParameters renewerParameters) {
        TokenProviderParameters providerParameters = new TokenProviderParameters();
        providerParameters.setAppliesToAddress(renewerParameters.getAppliesToAddress());
        providerParameters.setEncryptionProperties(renewerParameters.getEncryptionProperties());
        providerParameters.setKeyRequirements(renewerParameters.getKeyRequirements());
        providerParameters.setPrincipal(renewerParameters.getPrincipal());
        providerParameters.setRealm(renewerParameters.getRealm());
        providerParameters.setStsProperties(renewerParameters.getStsProperties());
        providerParameters.setTokenRequirements(renewerParameters.getTokenRequirements());
        providerParameters.setTokenStore(renewerParameters.getTokenStore());
        providerParameters.setMessageContext(renewerParameters.getMessageContext());
        Map<String, Object> additionalProperties = renewerParameters.getAdditionalProperties();
        if (additionalProperties == null) {
            additionalProperties = new HashMap<String, Object>(1);
        }
        additionalProperties.put(ReceivedToken.class.getName(), renewerParameters.getToken());
        providerParameters.setAdditionalProperties(additionalProperties);
        return providerParameters;
    }

    private String createNewId(SamlAssertionWrapper assertion) {
        if (assertion.getSaml1() != null) {
            Assertion saml1Assertion = assertion.getSaml1();
            String oldId = saml1Assertion.getID();
            saml1Assertion.setID(IDGenerator.generateID((String)"_"));
            return oldId;
        }
        org.opensaml.saml.saml2.core.Assertion saml2Assertion = assertion.getSaml2();
        String oldId = saml2Assertion.getID();
        saml2Assertion.setID(IDGenerator.generateID((String)"_"));
        return oldId;
    }

    private void storeTokenInCache(TokenStore tokenStore, SamlAssertionWrapper assertion, Principal principal, TokenRenewerParameters tokenParameters) throws WSSecurityException {
        byte[] signatureValue = assertion.getSignatureValue();
        if (tokenStore != null && signatureValue != null && signatureValue.length > 0) {
            DateTime validTill = null;
            validTill = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? assertion.getSaml2().getConditions().getNotOnOrAfter() : assertion.getSaml1().getConditions().getNotOnOrAfter();
            SecurityToken securityToken = CacheUtils.createSecurityTokenForStorage(assertion.getElement(), assertion.getId(), validTill.toDate(), tokenParameters.getPrincipal(), tokenParameters.getRealm(), tokenParameters.getTokenRequirements().getRenewing());
            CacheUtils.storeTokenInCache(securityToken, tokenParameters.getTokenStore(), signatureValue);
        }
    }

    private DateTime getExpiryDate(SamlAssertionWrapper assertion) {
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
            return assertion.getSaml2().getConditions().getNotOnOrAfter();
        }
        return assertion.getSaml1().getConditions().getNotOnOrAfter();
    }

    private static class ProofOfPossessionValidator {
        private ProofOfPossessionValidator() {
        }

        public boolean checkProofOfPossession(TokenRenewerParameters tokenParameters, SAMLKeyInfo subjectKeyInfo) {
            Map<String, Object> messageContext = tokenParameters.getMessageContext();
            List handlerResults = CastUtils.cast((List)((List)messageContext.get("RECV_RESULTS")));
            ArrayList signedResults = new ArrayList();
            if (handlerResults != null && handlerResults.size() > 0) {
                WSHandlerResult handlerResult = (WSHandlerResult)handlerResults.get(0);
                if (handlerResult.getActionResults().containsKey(2)) {
                    signedResults.addAll((Collection)handlerResult.getActionResults().get(2));
                }
                if (handlerResult.getActionResults().containsKey(64)) {
                    signedResults.addAll((Collection)handlerResult.getActionResults().get(64));
                }
            }
            TLSSessionInfo tlsInfo = (TLSSessionInfo)messageContext.get(TLSSessionInfo.class.getName());
            Certificate[] tlsCerts = null;
            if (tlsInfo != null) {
                tlsCerts = tlsInfo.getPeerCertificates();
            }
            return DOMSAMLUtil.compareCredentials((SAMLKeyInfo)subjectKeyInfo, signedResults, (Certificate[])tlsCerts);
        }
    }
}

