/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.plugin.AuthorizationPlugIn;
import org.jboss.as.domain.management.plugin.PlugInConfigurationSupport;
import org.jboss.as.domain.management.security.AbstractPlugInService;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class PlugInSubjectSupplemental
extends AbstractPlugInService
implements Service<SubjectSupplementalService>,
SubjectSupplementalService {
    private static final String SERVICE_SUFFIX = "plug-in-authorization";

    PlugInSubjectSupplemental(String realmName, String name, Map<String, String> properties) {
        super(realmName, name, properties);
    }

    public SubjectSupplementalService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new SecurityRealmImpl();
    }

    @Override
    public SubjectSupplemental getSubjectSupplemental(Map<String, Object> sharedState) {
        String name = this.getPlugInName();
        final AuthorizationPlugIn ap = this.getPlugInLoader().loadAuthorizationPlugIn(name);
        if (ap instanceof PlugInConfigurationSupport) {
            PlugInConfigurationSupport pcf = (PlugInConfigurationSupport)((Object)ap);
            try {
                pcf.init(this.getConfiguration(), sharedState);
            }
            catch (IOException e) {
                throw DomainManagementLogger.ROOT_LOGGER.unableToInitialisePlugIn(name, e.getMessage());
            }
        }
        return new SubjectSupplemental(){

            @Override
            public void supplementSubject(Subject subject) throws IOException {
                Set<RealmUser> users = subject.getPrincipals(RealmUser.class);
                Set<Principal> principals = subject.getPrincipals();
                for (RealmUser current : users) {
                    principals.addAll(this.loadGroups(current));
                }
            }

            private Set<RealmGroup> loadGroups(RealmUser user) throws IOException {
                String[] groups = ap.loadRoles(user.getName(), PlugInSubjectSupplemental.this.getRealmName());
                HashSet<RealmGroup> response = new HashSet<RealmGroup>(groups.length);
                for (String current : groups) {
                    RealmGroup newGroup = new RealmGroup(PlugInSubjectSupplemental.this.getRealmName(), current);
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Adding group '%s' for user '%s'.", newGroup, user);
                    response.add(newGroup);
                }
                return response;
            }
        };
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{PlugInSubjectSupplemental.SERVICE_SUFFIX});
        }
    }

    private class SecurityRealmImpl
    implements SecurityRealm {
        private SecurityRealmImpl() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            try {
                String name = PlugInSubjectSupplemental.this.getPlugInName();
                AuthorizationPlugIn ap = PlugInSubjectSupplemental.this.getPlugInLoader().loadAuthorizationPlugIn(name);
                if (ap instanceof PlugInConfigurationSupport) {
                    PlugInConfigurationSupport pcf = (PlugInConfigurationSupport)((Object)ap);
                    try {
                        pcf.init(PlugInSubjectSupplemental.this.getConfiguration(), SecurityRealmService.SharedStateSecurityRealm.getSharedState());
                    }
                    catch (IOException e) {
                        throw DomainManagementLogger.ROOT_LOGGER.unableToInitialisePlugIn(name, e.getMessage());
                    }
                }
                String[] groups = ap.loadRoles(principal.getName(), PlugInSubjectSupplemental.this.getRealmName());
                if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                    for (String group : groups) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Adding group '%s' for identity '%s'.", group, principal.getName());
                    }
                }
                return new RealmIdentityImpl(principal, groups);
            }
            catch (IOException e) {
                throw new RealmUnavailableException((Throwable)e);
            }
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        private class RealmIdentityImpl
        implements RealmIdentity {
            private final Principal principal;
            private final String[] groups;

            private RealmIdentityImpl(Principal principal, String[] groups) {
                this.principal = principal;
                this.groups = groups;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return false;
            }

            public boolean exists() throws RealmUnavailableException {
                return true;
            }

            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                HashMap<String, List<String>> groupsAttributeMap = new HashMap<String, List<String>>();
                groupsAttributeMap.put("GROUPS", Arrays.asList(this.groups));
                return AuthorizationIdentity.basicIdentity((Attributes)new MapAttributes(Collections.unmodifiableMap(groupsAttributeMap)));
            }
        }
    }
}

