/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import java.util.Iterator;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.Server;
import org.wildfly.extension.undertow.SessionCookieConfig;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.mod_cluster.undertow.UndertowConnector;
import org.wildfly.mod_cluster.undertow.UndertowHost;
import org.wildfly.mod_cluster.undertow.UndertowServer;

public class UndertowEngine
implements Engine {
    private final org.wildfly.extension.undertow.Server server;
    private final UndertowService service;
    private final Connector connector;

    public UndertowEngine(org.wildfly.extension.undertow.Server server, UndertowService service, Connector connector) {
        this.server = server;
        this.service = service;
        this.connector = connector;
    }

    public String getName() {
        return this.server.getName();
    }

    public Server getServer() {
        return new UndertowServer(this.service, this.connector);
    }

    public Iterable<Host> getHosts() {
        final Iterator hosts = this.server.getHosts().iterator();
        final Iterator<Host> iterator = new Iterator<Host>(){

            @Override
            public boolean hasNext() {
                return hosts.hasNext();
            }

            @Override
            public Host next() {
                org.wildfly.extension.undertow.Host host = (org.wildfly.extension.undertow.Host)hosts.next();
                return new UndertowHost(host, UndertowEngine.this);
            }

            @Override
            public void remove() {
                hosts.remove();
            }
        };
        return new Iterable<Host>(){

            @Override
            public Iterator<Host> iterator() {
                return iterator;
            }
        };
    }

    public Connector getProxyConnector() {
        return this.connector;
    }

    public Iterable<Connector> getConnectors() {
        final Iterator listeners = this.server.getListeners().iterator();
        final Iterator<Connector> iterator = new Iterator<Connector>(){

            @Override
            public boolean hasNext() {
                return listeners.hasNext();
            }

            @Override
            public Connector next() {
                return new UndertowConnector((UndertowListener)listeners.next());
            }

            @Override
            public void remove() {
                listeners.remove();
            }
        };
        return new Iterable<Connector>(){

            @Override
            public Iterator<Connector> iterator() {
                return iterator;
            }
        };
    }

    public String getJvmRoute() {
        return this.service.getInstanceId();
    }

    public void setJvmRoute(String jvmRoute) {
        this.service.setInstanceId(jvmRoute);
    }

    public Host findHost(String name) {
        for (org.wildfly.extension.undertow.Host host : this.server.getHosts()) {
            if (!host.getName().equals(name)) continue;
            return new UndertowHost(host, this);
        }
        return null;
    }

    public String getSessionCookieName() {
        SessionCookieConfig override = this.server.getServletContainer().getSessionCookieConfig();
        if (override == null || override.getName() == null) {
            return "JSESSIONID";
        }
        return override.getName();
    }

    public String getSessionParameterName() {
        return this.getSessionCookieName().toLowerCase();
    }

    public String getDefaultHost() {
        return this.server.getDefaultHost();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowEngine)) {
            return false;
        }
        UndertowEngine engine = (UndertowEngine)object;
        return this.getName().equals(engine.getName());
    }

    public int hashCode() {
        return this.server.getName().hashCode();
    }
}

