/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.NullConduitSelector;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.OneShotAsyncExecutor;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;

final class InternalContextUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(InternalContextUtils.class);

    private InternalContextUtils() {
    }

    public static void rebaseResponse(EndpointReferenceType reference, AddressingProperties inMAPs, Message inMessage) {
        String namespaceURI = inMAPs.getNamespaceURI();
        if (!ContextUtils.retrievePartialResponseSent((Message)inMessage)) {
            ContextUtils.storePartialResponseSent((Message)inMessage);
            Exchange exchange = inMessage.getExchange();
            Message fullResponse = exchange.getOutMessage();
            Message partialResponse = ContextUtils.createMessage((Exchange)exchange);
            InternalContextUtils.ensurePartialResponseMAPs(partialResponse, namespaceURI);
            ContextUtils.propogateReceivedMAPs((AddressingProperties)inMAPs, (Message)partialResponse);
            Destination target = inMessage.getDestination();
            if (target == null) {
                return;
            }
            try {
                Conduit backChannel;
                if (reference == null) {
                    reference = ContextUtils.getNoneEndpointReference();
                }
                if ((backChannel = target.getBackChannel(inMessage)) != null) {
                    partialResponse.put((Object)"org.apache.cxf.partial.response", (Object)Boolean.TRUE);
                    partialResponse.put((Object)"org.apache.cxf.partial.response.empty", (Object)Boolean.TRUE);
                    boolean robust = MessageUtils.isTrue((Object)inMessage.getContextualProperty("org.apache.cxf.oneway.robust"));
                    if (robust) {
                        BindingOperationInfo boi = exchange.getBindingOperationInfo();
                        exchange.put(Executor.class, (Object)InternalContextUtils.getExecutor(inMessage));
                        inMessage.getInterceptorChain().pause();
                        inMessage.getInterceptorChain().resume();
                        exchange.put(BindingOperationInfo.class, (Object)boi);
                    }
                    InterceptorChain chain = fullResponse != null ? fullResponse.getInterceptorChain() : OutgoingChainInterceptor.getOutInterceptorChain((Exchange)exchange);
                    exchange.setOutMessage(partialResponse);
                    partialResponse.setInterceptorChain(chain);
                    exchange.put(ConduitSelector.class, (Object)new PreexistingConduitSelector(backChannel, exchange.getEndpoint()));
                    if (chain != null && !chain.doIntercept(partialResponse) && partialResponse.getContent(Exception.class) != null) {
                        if (partialResponse.getContent(Exception.class) instanceof Fault) {
                            throw (Fault)((Object)partialResponse.getContent(Exception.class));
                        }
                        throw new Fault((Throwable)partialResponse.getContent(Exception.class));
                    }
                    if (chain != null) {
                        chain.reset();
                    }
                    exchange.put(ConduitSelector.class, (Object)new NullConduitSelector());
                    if (fullResponse == null) {
                        fullResponse = ContextUtils.createMessage((Exchange)exchange);
                    }
                    exchange.setOutMessage(fullResponse);
                    Destination destination = InternalContextUtils.createDecoupledDestination(exchange, reference);
                    exchange.setDestination(destination);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "SERVER_TRANSPORT_REBASE_FAILURE_MSG", e);
            }
        }
    }

    private static Destination createDecoupledDestination(Exchange exchange, EndpointReferenceType reference) {
        EndpointInfo ei = exchange.getEndpoint().getEndpointInfo();
        return new DecoupledDestination(ei, reference);
    }

    private static void ensurePartialResponseMAPs(Message partialResponse, String namespaceURI) {
        AddressingProperties maps = new AddressingProperties();
        maps.setTo(EndpointReferenceUtils.getAnonymousEndpointReference());
        maps.setReplyTo(ContextUtils.WSA_OBJECT_FACTORY.createEndpointReferenceType());
        maps.getReplyTo().setAddress(ContextUtils.getAttributedURI((String)"http://www.w3.org/2005/08/addressing/none"));
        maps.setAction(ContextUtils.getAttributedURI((String)""));
        maps.exposeAs(namespaceURI);
        ContextUtils.storeMAPs((AddressingProperties)maps, (Message)partialResponse, (boolean)true, (boolean)true, (boolean)false);
    }

    private static Executor getExecutor(Message message) {
        Endpoint endpoint = message.getExchange().getEndpoint();
        Executor executor = endpoint.getService().getExecutor();
        if (executor == null || SynchronousExecutor.isA((Executor)executor)) {
            WorkQueueManager workQueueManager;
            AutomaticWorkQueue autoWorkQueue;
            Bus bus = message.getExchange().getBus();
            executor = bus != null ? ((autoWorkQueue = (workQueueManager = (WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getNamedWorkQueue("ws-addressing")) != null ? autoWorkQueue : workQueueManager.getAutomaticWorkQueue()) : OneShotAsyncExecutor.getInstance();
        }
        message.getExchange().put(Executor.class, (Object)executor);
        return executor;
    }

    private static final class DecoupledDestination
    implements Destination {
        private final EndpointInfo ei;
        private final EndpointReferenceType reference;

        private DecoupledDestination(EndpointInfo ei, EndpointReferenceType reference) {
            this.ei = ei;
            this.reference = reference;
        }

        public EndpointReferenceType getAddress() {
            return this.reference;
        }

        public Conduit getBackChannel(Message inMessage) throws IOException {
            if (ContextUtils.isNoneAddress((EndpointReferenceType)this.reference)) {
                return null;
            }
            Bus bus = inMessage.getExchange().getBus();
            inMessage.getExchange().setOneWay(true);
            ConduitInitiator conduitInitiator = ((ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiatorForUri(this.reference.getAddress().getValue());
            if (conduitInitiator != null) {
                Conduit c = conduitInitiator.getConduit(this.ei, this.reference, bus);
                c.setMessageObserver(new MessageObserver(){

                    public void onMessage(Message m) {
                        InputStream is = (InputStream)m.getContent(InputStream.class);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                return c;
            }
            return null;
        }

        public MessageObserver getMessageObserver() {
            return null;
        }

        public void shutdown() {
        }

        public void setMessageObserver(MessageObserver observer) {
        }
    }
}

