/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Serializable;
import java.util.Objects;
import org.wildfly.common.Assert;

public final class EJBIdentifier
implements Serializable {
    private static final long serialVersionUID = 7065644117552778408L;
    private final String appName;
    private final String moduleName;
    private final String beanName;
    private final String distinctName;
    private transient int hashCode;

    public EJBIdentifier(String appName, String moduleName, String beanName, String distinctName) {
        Assert.checkNotNullParam("appName", appName);
        Assert.checkNotNullParam("moduleName", moduleName);
        Assert.checkNotEmptyParam("moduleName", moduleName);
        Assert.checkNotNullParam("beanName", beanName);
        Assert.checkNotEmptyParam("beanName", beanName);
        Assert.checkNotNullParam("distinctName", distinctName);
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
        this.distinctName = distinctName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public boolean equals(Object other) {
        return other instanceof EJBIdentifier && this.equals((EJBIdentifier)other);
    }

    public boolean equals(EJBIdentifier other) {
        return other != null && (other == this || other.hashCode() == this.hashCode() && Objects.equals(this.appName, other.appName) && Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.beanName, other.beanName) && Objects.equals(this.distinctName, other.distinctName));
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode != 0) {
            return hashCode;
        }
        hashCode = Objects.hashCode(this.appName) + 13 * (Objects.hashCode(this.moduleName) + 13 * (Objects.hashCode(this.beanName) + 13 * Objects.hashCode(this.distinctName)));
        this.hashCode = hashCode == 0 ? 1 : hashCode;
        return this.hashCode;
    }

    public String toString() {
        String distinctName = this.getDistinctName();
        if (distinctName == null || distinctName.isEmpty()) {
            return String.format("%s/%s/%s", this.getAppName(), this.getModuleName(), this.getBeanName());
        }
        return String.format("%s/%s/%s/%s", this.getAppName(), this.getModuleName(), this.getBeanName(), distinctName);
    }
}

