/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.security.Permission;

public final class EJBClientPermission
extends Permission {
    private static final long serialVersionUID = 8406360684253911321L;
    static final Name[] values = Name.values();
    private transient Name name;

    public EJBClientPermission(String name) {
        this(Name.of(name));
    }

    public EJBClientPermission(String name, String actions) {
        this(Name.of(name));
        if (actions != null && !actions.isEmpty()) {
            throw new IllegalArgumentException("Unsupported actions string '" + actions + "'");
        }
    }

    EJBClientPermission(Name name) {
        super(name.name());
        this.name = name;
    }

    @Override
    public boolean implies(Permission permission) {
        return permission instanceof EJBClientPermission && this.implies((EJBClientPermission)permission);
    }

    public boolean implies(EJBClientPermission permission) {
        return permission != null && this.name == permission.name;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof EJBClientPermission && this.equals((EJBClientPermission)obj);
    }

    public boolean equals(Permission obj) {
        return obj instanceof EJBClientPermission && this.equals((EJBClientPermission)obj);
    }

    public boolean equals(EJBClientPermission obj) {
        return obj != null && this.name == obj.name;
    }

    @Override
    public int hashCode() {
        return this.name.ordinal();
    }

    @Override
    public String getActions() {
        return "";
    }

    static enum Name {
        createContext,
        createReceiver,
        changeWeakAffinity,
        changeStrongAffinity;


        public static Name of(String name) {
            try {
                return Name.valueOf(name);
            }
            catch (IllegalArgumentException ignored) {
                throw new IllegalArgumentException("Invalid permission name " + name);
            }
        }
    }
}

