/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.w3c.dom.Element;

public class SpnegoContextToken
extends AbstractToken {
    private boolean mustNotSendCancel;
    private boolean mustNotSendAmend;
    private boolean mustNotSendRenew;

    public SpnegoContextToken(SPConstants.SPVersion version, SPConstants.IncludeTokenType includeTokenType, Element issuer, String issuerName, Element claims, Policy nestedPolicy) {
        super(version, includeTokenType, issuer, issuerName, claims, nestedPolicy);
        this.parseNestedPolicy(nestedPolicy, this);
    }

    public QName getName() {
        return this.getVersion().getSPConstants().getSpnegoContextToken();
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new SpnegoContextToken(this.getVersion(), this.getIncludeTokenType(), this.getIssuer(), this.getIssuerName(), this.getClaims(), nestedPolicy);
    }

    protected void parseNestedPolicy(Policy nestedPolicy, SpnegoContextToken spnegoContextToken) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                AbstractToken.DerivedKeys derivedKeys = AbstractToken.DerivedKeys.lookUp(assertionName);
                if (derivedKeys != null) {
                    if (spnegoContextToken.getDerivedKeys() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    spnegoContextToken.setDerivedKeys(derivedKeys);
                    continue;
                }
                QName mustNotSendCancel = this.getVersion().getSPConstants().getMustNotSendCancel();
                if (mustNotSendCancel.getLocalPart().equals(assertionName) && mustNotSendCancel.getNamespaceURI().equals(assertionNamespace)) {
                    if (spnegoContextToken.isMustNotSendCancel()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    spnegoContextToken.setMustNotSendCancel(true);
                    continue;
                }
                QName mustNotSendAmend = this.getVersion().getSPConstants().getMustNotSendAmend();
                if (mustNotSendAmend.getLocalPart().equals(assertionName) && mustNotSendAmend.getNamespaceURI().equals(assertionNamespace)) {
                    if (spnegoContextToken.isMustNotSendAmend()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    spnegoContextToken.setMustNotSendAmend(true);
                    continue;
                }
                QName mustNotSendRenew = this.getVersion().getSPConstants().getMustNotSendRenew();
                if (!mustNotSendRenew.getLocalPart().equals(assertionName) || !mustNotSendRenew.getNamespaceURI().equals(assertionNamespace)) continue;
                if (spnegoContextToken.isMustNotSendRenew()) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                spnegoContextToken.setMustNotSendRenew(true);
            }
        }
    }

    public boolean isMustNotSendCancel() {
        return this.mustNotSendCancel;
    }

    protected void setMustNotSendCancel(boolean mustNotSendCancel) {
        this.mustNotSendCancel = mustNotSendCancel;
    }

    public boolean isMustNotSendAmend() {
        return this.mustNotSendAmend;
    }

    protected void setMustNotSendAmend(boolean mustNotSendAmend) {
        this.mustNotSendAmend = mustNotSendAmend;
    }

    public boolean isMustNotSendRenew() {
        return this.mustNotSendRenew;
    }

    protected void setMustNotSendRenew(boolean mustNotSendRenew) {
        this.mustNotSendRenew = mustNotSendRenew;
    }
}

