/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ListenerRegistry;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.HttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.UndertowListener;
import org.xnio.OptionMap;

public class HttpListenerAdd
extends ListenerAdd {
    static final ServiceName REGISTRY_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"http", "listener", "registry"});

    HttpListenerAdd(ListenerResourceDefinition definition) {
        super(definition);
    }

    @Override
    ListenerService createService(String name, String serverName, OperationContext context, ModelNode model, OptionMap listenerOptions, OptionMap socketOptions) throws OperationFailedException {
        boolean certificateForwarding = HttpListenerResourceDefinition.CERTIFICATE_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        boolean proxyAddressForwarding = HttpListenerResourceDefinition.PROXY_ADDRESS_FORWARDING.resolveModelAttribute(context, model).asBoolean();
        OptionMap.Builder listenerBuilder = OptionMap.builder().addAll(listenerOptions);
        HttpListenerResourceDefinition.ENABLE_HTTP2.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerResourceDefinition.REQUIRE_HOST_HTTP11.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerAdd.handleHttp2Options(context, model, listenerBuilder);
        return new HttpListenerService(name, serverName, listenerBuilder.getMap(), socketOptions, certificateForwarding, proxyAddressForwarding);
    }

    static void handleHttp2Options(OperationContext context, ModelNode model, OptionMap.Builder listenerBuilder) throws OperationFailedException {
        HttpListenerResourceDefinition.HTTP2_ENABLE_PUSH.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerResourceDefinition.HTTP2_HEADER_TABLE_SIZE.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerResourceDefinition.HTTP2_INITIAL_WINDOW_SIZE.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerResourceDefinition.HTTP2_MAX_CONCURRENT_STREAMS.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerResourceDefinition.HTTP2_MAX_FRAME_SIZE.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        HttpListenerResourceDefinition.HTTP2_MAX_HEADER_LIST_SIZE.resolveOption((ExpressionResolver)context, model, listenerBuilder);
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, ServiceBuilder<? extends UndertowListener> serviceBuilder, ModelNode model, ListenerService service) throws OperationFailedException {
        ModelNode redirectBindingRef = ListenerResourceDefinition.REDIRECT_SOCKET.resolveModelAttribute(context, model);
        if (redirectBindingRef.isDefined()) {
            serviceBuilder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{redirectBindingRef.asString()}), SocketBinding.class, service.getRedirectSocket());
        }
        serviceBuilder.addDependency(REGISTRY_SERVICE_NAME, ListenerRegistry.class, ((HttpListenerService)service).getHttpListenerRegistry());
    }
}

