/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import org.jboss.as.clustering.controller.BinaryRequirementAliasBuilder;
import org.jboss.as.clustering.controller.BinaryServiceNameFactory;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.spi.CacheAliasBuilderProvider;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class CacheRequirementAliasBuilderProvider
implements CacheAliasBuilderProvider {
    private final ClusteringCacheRequirement requirement;
    private final BiFunction<String, String, JndiName> jndiNameFactory;

    protected CacheRequirementAliasBuilderProvider(ClusteringCacheRequirement requirement) {
        this(requirement, null);
    }

    protected CacheRequirementAliasBuilderProvider(ClusteringCacheRequirement requirement, BiFunction<String, String, JndiName> jndiNameFactory) {
        this.requirement = requirement;
        this.jndiNameFactory = jndiNameFactory;
    }

    public Collection<CapabilityServiceBuilder<?>> getBuilders(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String aliasCacheName, String targetCacheName) {
        BinaryRequirementAliasBuilder builder = new BinaryRequirementAliasBuilder(registry.getServiceName((Requirement)this.requirement), (BinaryServiceNameFactory)this.requirement, containerName, targetCacheName, this.requirement.getType());
        if (this.jndiNameFactory == null || "default".equals(targetCacheName)) {
            return Collections.singleton(builder);
        }
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(containerName, aliasCacheName).getAbsoluteName());
        BinderServiceBuilder binderBuilder = new BinderServiceBuilder(binding, builder.getServiceName(), this.requirement.getType());
        return Arrays.asList(builder, binderBuilder);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

