/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ServiceLoader;
import javax.annotation.Resource;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.ee.component.EEDefaultResourceJndiNames;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.bootstrap.AbstractResourceInjectionServices;
import org.jboss.as.weld.spi.ResourceInjectionResolver;
import org.jboss.as.weld.util.ResourceInjectionUtilities;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldResourceInjectionServices
extends AbstractResourceInjectionServices
implements ResourceInjectionServices {
    private static final String USER_TRANSACTION_LOCATION = "java:comp/UserTransaction";
    private static final String USER_TRANSACTION_CLASS_NAME = "javax.transaction.UserTransaction";
    private static final String HANDLE_DELEGATE_CLASS_NAME = "javax.ejb.spi.HandleDelegate";
    private static final String TIMER_SERVICE_CLASS_NAME = "javax.ejb.TimerService";
    private static final String ORB_CLASS_NAME = "org.omg.CORBA.ORB";
    private static final String TRANSACTION_SYNC_REGISTRY_LOCATION = "java:comp/TransactionSynchronizationRegistry";
    private static final String TRANSACTION_SYNC_REGISTRY_CLASS_NAME = "javax.transaction.TransactionSynchronizationRegistry";
    private static final String EE_CONTEXT_SERVICE_CLASS_NAME = "javax.enterprise.concurrent.ContextService";
    private static final String EE_DATASOURCE_CLASS_NAME = "javax.sql.DataSource";
    private static final String EE_JMS_CONNECTION_FACTORY_CLASS_NAME = "javax.jms.ConnectionFactory";
    private static final String EE_MANAGED_EXECUTOR_SERVICE_CLASS_NAME = "javax.enterprise.concurrent.ManagedExecutorService";
    private static final String EE_MANAGED_SCHEDULED_EXECUTOR_SERVICE_CLASS_NAME = "javax.enterprise.concurrent.ManagedScheduledExecutorService";
    private static final String EE_MANAGED_THREAD_FACTORY_CLASS_NAME = "javax.enterprise.concurrent.ManagedThreadFactory";
    private static final String EJB_CONTEXT_LOCATION = "java:comp/EJBContext";
    private static final String EJB_CONTEXT_CLASS_NAME = "javax.ejb.EJBContext";
    private static final String EJB_SESSION_CONTEXT_CLASS_NAME = "javax.ejb.SessionContext";
    private static final String EJB_MESSAGE_DRIVEN_CONTEXT_CLASS_NAME = "javax.ejb.MessageDrivenContext";
    private static final String EJB_ENTITY_CONTEXT_CLASS_NAME = "javax.ejb.EntityContext";
    private static final String WEB_SERVICE_CONTEXT_CLASS_NAME = "javax.xml.ws.WebServiceContext";
    private final Context context;
    private final boolean warModule;
    private final Iterable<ResourceInjectionResolver> resourceResolvers;

    public WeldResourceInjectionServices(ServiceRegistry serviceRegistry, EEModuleDescription moduleDescription, Module module, boolean warModule) {
        super(serviceRegistry, moduleDescription, module);
        this.warModule = warModule;
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.resourceResolvers = ServiceLoader.load(ResourceInjectionResolver.class, WildFlySecurityManager.getClassLoaderPrivileged(WeldResourceInjectionServices.class));
    }

    protected String getEJBResourceName(InjectionPoint injectionPoint, String proposedName) {
        if (injectionPoint.getType() instanceof Class) {
            Class type = (Class)injectionPoint.getType();
            String typeName = type.getName();
            if (USER_TRANSACTION_CLASS_NAME.equals(typeName)) {
                return USER_TRANSACTION_LOCATION;
            }
            if (HANDLE_DELEGATE_CLASS_NAME.equals(typeName)) {
                WeldLogger.ROOT_LOGGER.injectionTypeNotValue(HANDLE_DELEGATE_CLASS_NAME, injectionPoint.getMember());
                return proposedName;
            }
            if (ORB_CLASS_NAME.equals(typeName)) {
                WeldLogger.ROOT_LOGGER.injectionTypeNotValue(ORB_CLASS_NAME, injectionPoint.getMember());
                return proposedName;
            }
            if (TIMER_SERVICE_CLASS_NAME.equals(typeName)) {
                WeldLogger.ROOT_LOGGER.injectionTypeNotValue(TIMER_SERVICE_CLASS_NAME, injectionPoint.getMember());
                return proposedName;
            }
            if (EJB_CONTEXT_CLASS_NAME.equals(typeName) || EJB_SESSION_CONTEXT_CLASS_NAME.equals(typeName) || EJB_MESSAGE_DRIVEN_CONTEXT_CLASS_NAME.equals(typeName) || EJB_ENTITY_CONTEXT_CLASS_NAME.equals(typeName)) {
                return EJB_CONTEXT_LOCATION;
            }
            if (WEB_SERVICE_CONTEXT_CLASS_NAME.equals(typeName)) {
                return WEB_SERVICE_CONTEXT_CLASS_NAME;
            }
            if (TRANSACTION_SYNC_REGISTRY_CLASS_NAME.equals(typeName)) {
                return TRANSACTION_SYNC_REGISTRY_LOCATION;
            }
            EEDefaultResourceJndiNames eeDefaultResourceJndiNames = this.moduleDescription.getDefaultResourceJndiNames();
            if (eeDefaultResourceJndiNames.getContextService() != null && EE_CONTEXT_SERVICE_CLASS_NAME.equals(typeName)) {
                return eeDefaultResourceJndiNames.getContextService();
            }
            if (eeDefaultResourceJndiNames.getDataSource() != null && EE_DATASOURCE_CLASS_NAME.equals(typeName)) {
                return eeDefaultResourceJndiNames.getDataSource();
            }
            if (eeDefaultResourceJndiNames.getJmsConnectionFactory() != null && EE_JMS_CONNECTION_FACTORY_CLASS_NAME.equals(typeName)) {
                return eeDefaultResourceJndiNames.getJmsConnectionFactory();
            }
            if (eeDefaultResourceJndiNames.getManagedExecutorService() != null && EE_MANAGED_EXECUTOR_SERVICE_CLASS_NAME.equals(typeName)) {
                return eeDefaultResourceJndiNames.getManagedExecutorService();
            }
            if (eeDefaultResourceJndiNames.getManagedScheduledExecutorService() != null && EE_MANAGED_SCHEDULED_EXECUTOR_SERVICE_CLASS_NAME.equals(typeName)) {
                return eeDefaultResourceJndiNames.getManagedScheduledExecutorService();
            }
            if (eeDefaultResourceJndiNames.getManagedThreadFactory() != null && EE_MANAGED_THREAD_FACTORY_CLASS_NAME.equals(typeName)) {
                return eeDefaultResourceJndiNames.getManagedThreadFactory();
            }
        }
        return proposedName;
    }

    protected String getResourceName(InjectionPoint injectionPoint) {
        Resource resource = (Resource)ResourceInjectionUtilities.getResourceAnnotated((InjectionPoint)injectionPoint).getAnnotation(Resource.class);
        String mappedName = resource.mappedName();
        String lookup = resource.lookup();
        if (!lookup.isEmpty()) {
            return lookup;
        }
        if (!mappedName.isEmpty()) {
            return mappedName;
        }
        String proposedName = ResourceInjectionUtilities.getResourceName((InjectionPoint)injectionPoint);
        return this.getEJBResourceName(injectionPoint, proposedName);
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(final InjectionPoint injectionPoint) {
        String result = this.getResourceName(injectionPoint);
        if (this.isKnownNamespace(result) && injectionPoint.getAnnotated().isAnnotationPresent(Produces.class)) {
            this.validateResourceInjectionPointType(this.getManagedReferenceFactory(this.getBindInfo(result)), injectionPoint);
        }
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                return new SimpleResourceReference(WeldResourceInjectionServices.this.resolveResource(injectionPoint));
            }
        };
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(final String jndiName, final String mappedName) {
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                return new SimpleResourceReference(WeldResourceInjectionServices.this.resolveResource(jndiName, mappedName));
            }
        };
    }

    private boolean isKnownNamespace(String name) {
        return name.startsWith("java:global") || name.startsWith("java:app") || name.startsWith("java:module") || name.startsWith("java:comp") || name.startsWith("java:jboss");
    }

    public void cleanup() {
    }

    protected ContextNames.BindInfo getBindInfo(String result) {
        return ContextNames.bindInfoForEnvEntry((String)this.moduleDescription.getApplicationName(), (String)this.moduleDescription.getModuleName(), (String)this.moduleDescription.getModuleName(), (!this.warModule ? 1 : 0) != 0, (String)result);
    }

    public Object resolveResource(InjectionPoint injectionPoint) {
        Member member = injectionPoint.getMember();
        Object annotatedMember = injectionPoint.getAnnotated() instanceof AnnotatedField ? (AnnotatedField)injectionPoint.getAnnotated() : ((AnnotatedParameter)injectionPoint.getAnnotated()).getDeclaringCallable();
        if (!annotatedMember.isAnnotationPresent(Resource.class)) {
            throw WeldLogger.ROOT_LOGGER.annotationNotFound(Resource.class, member);
        }
        if (member instanceof Method && ((Method)member).getParameterTypes().length != 1) {
            throw WeldLogger.ROOT_LOGGER.injectionPointNotAJavabean((Method)member);
        }
        String name = this.getResourceName(injectionPoint);
        for (ResourceInjectionResolver resolver : this.resourceResolvers) {
            Object result = resolver.resolve(name);
            if (result == null) continue;
            return result;
        }
        try {
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            throw WeldLogger.ROOT_LOGGER.couldNotFindResource(name, injectionPoint.getMember().toString(), (Throwable)e);
        }
    }

    public Object resolveResource(String jndiName, String mappedName) {
        String name = ResourceInjectionUtilities.getResourceName((String)jndiName, (String)mappedName);
        try {
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            throw WeldLogger.ROOT_LOGGER.couldNotFindResource(name, (Throwable)e);
        }
    }
}

