/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class SecureExchangeAttribute
implements ExchangeAttribute {
    public static final String TOKEN = "${SECURE}";
    public static final ExchangeAttribute INSTANCE = new SecureExchangeAttribute();

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return Boolean.toString(exchange.getProtocol().equalToString("https"));
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("secure", newValue);
    }

    public static class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Secure";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(SecureExchangeAttribute.TOKEN)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

