/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class RemoveStepHandler
extends AbstractRemoveStepHandler
implements Registration<ManagementResourceRegistration> {
    private final RemoveStepHandlerDescriptor descriptor;
    private final ResourceServiceHandler handler;
    private final OperationEntry.Flag flag;

    public RemoveStepHandler(RemoveStepHandlerDescriptor descriptor, ResourceServiceHandler handler) {
        this(descriptor, handler, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
    }

    protected RemoveStepHandler(RemoveStepHandlerDescriptor descriptor, OperationEntry.Flag flag) {
        this(descriptor, null, flag);
    }

    private RemoveStepHandler(RemoveStepHandlerDescriptor descriptor, ResourceServiceHandler handler, OperationEntry.Flag flag) {
        this.descriptor = descriptor;
        this.handler = handler;
        this.flag = flag;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && this.handler != null;
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathElement path;
        PathAddress address;
        boolean remove;
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        boolean bl = remove = !resource.getChildTypes().stream().anyMatch(type -> resource.getChildren(type).stream().filter(entry -> !entry.isRuntime()).map(entry -> entry.getPathElement()).anyMatch(path -> resource.hasChild(path)));
        if (remove) {
            address = context.getCurrentAddress();
            this.descriptor.getCapabilities().entrySet().stream().filter(entry -> ((Predicate)entry.getValue()).test(model)).map(Map.Entry::getKey).forEach(capability -> context.deregisterCapability(capability.resolve(address).getName()));
            ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            registration.getAttributeNames(PathAddress.EMPTY_ADDRESS).stream().map(name -> registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, name)).filter(Objects::nonNull).map(AttributeAccess::getAttributeDefinition).filter(Objects::nonNull).filter(AttributeDefinition::hasCapabilityRequirements).forEach(attribute -> attribute.removeCapabilityRequirements(context, model.get(attribute.getName())));
            this.descriptor.getResourceCapabilityReferences().forEach((reference, resolver) -> reference.removeCapabilityRequirements(context, (String)null, new String[]{(String)resolver.apply(address)}));
            RemoveStepHandler.removeRuntimeChildren(context, PathAddress.EMPTY_ADDRESS);
        }
        super.performRemove(context, operation, model);
        if (remove && !(path = (address = context.getResourceRegistration().getPathAddress()).getLastElement()).isWildcard() && context.getResourceRegistration().getParent().getSubModel(PathAddress.pathAddress((String)path.getKey(), (String)"*")) != null) {
            context.getResourceRegistrationForUpdate().unregisterOverrideModel(context.getCurrentAddressValue());
        }
    }

    private static void removeRuntimeChildren(OperationContext context, PathAddress address) {
        Resource resource = context.readResource(address);
        for (String type : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(type)) {
                if (!entry.isRuntime()) continue;
                RemoveStepHandler.removeRuntimeChildren(context, address.append(new PathElement[]{entry.getPathElement()}));
                context.removeResource(address);
            }
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            this.handler.removeServices(context, model);
        } else {
            context.reloadRequired();
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isResourceServiceRestartAllowed()) {
            this.handler.installServices(context, model);
        } else {
            context.revertReloadRequired();
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("remove", this.descriptor.getDescriptionResolver()).withFlag(this.flag).build(), (OperationStepHandler)this);
    }
}

