/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.clustering.jgroups.TopologyAddressGenerator;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.fork.UnknownForkHandler;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;

public class JChannelFactory
implements ChannelFactory {
    static final ByteBuffer UNKNOWN_FORK_RESPONSE = ByteBuffer.allocate(0);
    private final ProtocolStackConfiguration configuration;

    public JChannelFactory(ProtocolStackConfiguration configuration) {
        this.configuration = configuration;
    }

    public ProtocolStackConfiguration getProtocolStackConfiguration() {
        return this.configuration;
    }

    public Channel createChannel(String id) throws Exception {
        final FORK fork = new FORK();
        fork.enableStats(this.configuration.isStatisticsEnabled());
        fork.setUnknownForkHandler(new UnknownForkHandler(){
            private final short id = ClassConfigurator.getProtocolId(RequestCorrelator.class);

            public Object handleUnknownForkStack(Message message, String forkStackId) {
                return this.handle(message);
            }

            public Object handleUnknownForkChannel(Message message, String forkChannelId) {
                return this.handle(message);
            }

            private Object handle(Message message) {
                RequestCorrelator.Header header = (RequestCorrelator.Header)message.getHeader(this.id);
                if (header != null && header.type == 0 && header.rspExpected()) {
                    Message response = message.makeReply().setFlag(message.getFlags()).clearFlag(new Message.Flag[]{Message.Flag.RSVP, Message.Flag.SCOPED});
                    response.putHeader(FORK.ID, message.getHeader(FORK.ID));
                    response.putHeader(this.id, (Header)new RequestCorrelator.Header(1, header.req_id, header.corrId));
                    response.setBuffer(UNKNOWN_FORK_RESPONSE.array());
                    fork.getProtocolStack().getChannel().down(new Event(1, (Object)response));
                }
                return null;
            }
        });
        Stream<TransportConfiguration> protocolConfigs = Stream.concat(Stream.of(this.configuration.getTransport()), this.configuration.getProtocols().stream());
        Stream relayConfig = Optional.ofNullable(this.configuration.getRelay()).map(Stream::of).orElse(Stream.empty());
        Stream<Protocol> protocols = Stream.concat(protocolConfigs, relayConfig).map(config -> config.createProtocol(this.configuration));
        JChannel channel = new JChannel((Collection)Stream.concat(protocols, Stream.of(fork)).collect(Collectors.toList()));
        channel.setName(this.configuration.getNodeName());
        TransportConfiguration.Topology topology = this.configuration.getTransport().getTopology();
        if (topology != null) {
            channel.addAddressGenerator((AddressGenerator)new TopologyAddressGenerator(topology));
        }
        return channel;
    }

    public boolean isUnknownForkResponse(ByteBuffer response) {
        return UNKNOWN_FORK_RESPONSE.equals(response);
    }
}

