/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.ForkChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolServiceNameProvider;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class ForkChannelFactoryBuilder
implements ResourceServiceBuilder<ChannelFactory>,
Value<ChannelFactory> {
    private final ServiceName serviceName;
    private final String channelName;
    private volatile List<ValueDependency<ProtocolConfiguration>> protocols;
    private volatile ValueDependency<Channel> parentChannel;
    private volatile ValueDependency<ChannelFactory> parentFactory;

    public ForkChannelFactoryBuilder(ServiceName serviceName, String channelName) {
        this.serviceName = serviceName;
        this.channelName = channelName;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).setInitialMode(ServiceController.Mode.PASSIVE);
        this.parentChannel.register(builder);
        this.parentFactory.register(builder);
        this.protocols.forEach(protocol -> protocol.register(builder));
        return builder;
    }

    public ChannelFactory getValue() {
        ArrayList<ProtocolConfiguration<? extends Protocol>> protocols = new ArrayList<ProtocolConfiguration<? extends Protocol>>(this.protocols.size());
        for (Value value : this.protocols) {
            ProtocolConfiguration protocol = (ProtocolConfiguration)value.getValue();
            protocols.add(protocol);
        }
        return new ForkChannelFactory((Channel)this.parentChannel.getValue(), (ChannelFactory)this.parentFactory.getValue(), protocols);
    }

    public Builder<ChannelFactory> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        this.protocols = resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).stream().filter(Resource::isModelDefined).map(entry -> new InjectedValueDependency((ServiceNameProvider)new ProtocolServiceNameProvider(address, entry.getPathElement()), ProtocolConfiguration.class)).collect(Collectors.toList());
        this.parentChannel = new InjectedValueDependency(JGroupsRequirement.CHANNEL.getServiceName(context, this.channelName), Channel.class);
        this.parentFactory = new InjectedValueDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(context, this.channelName), ChannelFactory.class);
        return this;
    }
}

