/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.event.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.PartitionStatusChangedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;

@NotThreadSafe
public class EventImpl<K, V>
implements CacheEntryActivatedEvent,
CacheEntryCreatedEvent,
CacheEntriesEvictedEvent,
CacheEntryLoadedEvent,
CacheEntryModifiedEvent,
CacheEntryPassivatedEvent,
CacheEntryRemovedEvent,
CacheEntryVisitedEvent,
TransactionCompletedEvent,
TransactionRegisteredEvent,
CacheEntryInvalidatedEvent,
DataRehashedEvent,
TopologyChangedEvent,
CacheEntryExpiredEvent,
PartitionStatusChangedEvent,
Cloneable {
    private boolean pre = false;
    private transient Cache<K, V> cache;
    private K key;
    private GlobalTransaction transaction;
    private Metadata metadata;
    private Metadata oldMetadata;
    private boolean originLocal = true;
    private boolean transactionSuccessful;
    private Event.Type type;
    private V value;
    private V oldValue;
    private ConsistentHash consistentHashAtStart;
    private ConsistentHash consistentHashAtEnd;
    private ConsistentHash unionConsistentHash;
    private int newTopologyId;
    private Map<? extends K, ? extends V> entries;
    private boolean created;
    private boolean commandRetried;
    private AvailabilityMode mode;

    public static <K, V> EventImpl<K, V> createEvent(Cache<K, V> cache, Event.Type type) {
        EventImpl<K, V> e = new EventImpl<K, V>();
        e.cache = cache;
        e.type = type;
        return e;
    }

    @Override
    public Event.Type getType() {
        return this.type;
    }

    @Override
    public boolean isPre() {
        return this.pre;
    }

    @Override
    public Cache<K, V> getCache() {
        return this.cache;
    }

    @Override
    public K getKey() {
        if (this.key instanceof MarshalledValue) {
            this.key = ((MarshalledValue)this.key).get();
        }
        return this.key;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isOriginLocal() {
        return this.originLocal;
    }

    @Override
    public boolean isTransactionSuccessful() {
        return this.transactionSuccessful;
    }

    public void setPre(boolean pre) {
        this.pre = pre;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setTransactionId(GlobalTransaction transaction) {
        this.transaction = transaction;
    }

    public void setOriginLocal(boolean originLocal) {
        this.originLocal = originLocal;
    }

    public void setTransactionSuccessful(boolean transactionSuccessful) {
        this.transactionSuccessful = transactionSuccessful;
    }

    public void setConsistentHashAtStart(ConsistentHash consistentHashAtStart) {
        this.consistentHashAtStart = consistentHashAtStart;
    }

    public void setConsistentHashAtEnd(ConsistentHash consistentHashAtEnd) {
        this.consistentHashAtEnd = consistentHashAtEnd;
    }

    public void setUnionConsistentHash(ConsistentHash unionConsistentHash) {
        this.unionConsistentHash = unionConsistentHash;
    }

    public void setNewTopologyId(int newTopologyId) {
        this.newTopologyId = newTopologyId;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setOldMetadata(Metadata metadata) {
        this.oldMetadata = metadata;
    }

    public Metadata getOldMetadata() {
        return this.oldMetadata;
    }

    @Override
    public V getValue() {
        if (this.value instanceof MarshalledValue) {
            this.value = ((MarshalledValue)this.value).get();
        }
        return this.value;
    }

    public void setCommandRetried(boolean commandRetried) {
        this.commandRetried = commandRetried;
    }

    @Override
    public boolean isCommandRetried() {
        return this.commandRetried;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public V getOldValue() {
        return this.oldValue;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public void setEntries(Map<? extends K, ? extends V> entries) {
        this.entries = entries;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }

    public void setOldValue(V oldValue) {
        this.oldValue = oldValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventImpl event = (EventImpl)o;
        if (this.originLocal != event.originLocal) {
            return false;
        }
        if (this.pre != event.pre) {
            return false;
        }
        if (this.transactionSuccessful != event.transactionSuccessful) {
            return false;
        }
        if (this.cache != null ? !this.cache.equals(event.cache) : event.cache != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(event.key) : event.key != null) {
            return false;
        }
        if (this.transaction != null ? !this.transaction.equals(event.transaction) : event.transaction != null) {
            return false;
        }
        if (this.type != event.type) {
            return false;
        }
        if (this.value != null ? !this.value.equals(event.value) : event.value != null) {
            return false;
        }
        if (!Util.safeEquals((Object)this.consistentHashAtStart, (Object)event.consistentHashAtStart)) {
            return false;
        }
        if (!Util.safeEquals((Object)this.consistentHashAtEnd, (Object)event.consistentHashAtEnd)) {
            return false;
        }
        if (!Util.safeEquals((Object)this.unionConsistentHash, (Object)event.unionConsistentHash)) {
            return false;
        }
        if (this.newTopologyId != event.newTopologyId) {
            return false;
        }
        if (this.created != event.created) {
            return false;
        }
        return !(this.oldValue != null ? !this.oldValue.equals(event.oldValue) : event.oldValue != null);
    }

    public int hashCode() {
        int result = this.pre ? 1 : 0;
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        result = 31 * result + (this.originLocal ? 1 : 0);
        result = 31 * result + (this.transactionSuccessful ? 1 : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.consistentHashAtStart != null ? this.consistentHashAtStart.hashCode() : 0);
        result = 31 * result + (this.consistentHashAtEnd != null ? this.consistentHashAtEnd.hashCode() : 0);
        result = 31 * result + (this.unionConsistentHash != null ? this.unionConsistentHash.hashCode() : 0);
        result = 31 * result + this.newTopologyId;
        result = 31 * result + (this.created ? 1 : 0);
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.type == Event.Type.TOPOLOGY_CHANGED || this.type == Event.Type.DATA_REHASHED) {
            return "EventImpl{type=" + (Object)((Object)this.type) + ", pre=" + this.pre + ", cache=" + this.cache + ", consistentHashAtStart=" + this.consistentHashAtStart + ", consistentHashAtEnd=" + this.consistentHashAtEnd + ", unionConsistentHash=" + this.unionConsistentHash + ", newTopologyId=" + this.newTopologyId + '}';
        }
        return "EventImpl{type=" + (Object)((Object)this.type) + ", pre=" + this.pre + ", cache=" + this.cache + ", key=" + this.key + ", value=" + this.value + ", oldValue=" + this.oldValue + ", transaction=" + this.transaction + ", originLocal=" + this.originLocal + ", transactionSuccessful=" + this.transactionSuccessful + ", entries=" + this.entries + ", created=" + this.created + '}';
    }

    @Override
    public Collection<Address> getMembersAtStart() {
        return this.consistentHashAtStart != null ? this.consistentHashAtStart.getMembers() : Collections.emptySet();
    }

    @Override
    public Collection<Address> getMembersAtEnd() {
        return this.consistentHashAtEnd != null ? this.consistentHashAtEnd.getMembers() : Collections.emptySet();
    }

    @Override
    public ConsistentHash getConsistentHashAtStart() {
        return this.consistentHashAtStart;
    }

    @Override
    public ConsistentHash getConsistentHashAtEnd() {
        return this.consistentHashAtEnd;
    }

    @Override
    public ConsistentHash getUnionConsistentHash() {
        return this.unionConsistentHash;
    }

    @Override
    public int getNewTopologyId() {
        return this.newTopologyId;
    }

    @Override
    public AvailabilityMode getAvailabilityMode() {
        return this.mode;
    }

    public void setAvailabilityMode(AvailabilityMode mode) {
        this.mode = mode;
    }

    public Map<? extends K, ? extends V> getEntries() {
        return this.entries;
    }

    public EventImpl<K, V> clone() {
        try {
            return (EventImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should never happen!", e);
        }
    }
}

