/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.List;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryType;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

public class ConnectionFactoryAdd
extends AbstractAddStepHandler {
    public static final ConnectionFactoryAdd INSTANCE = new ConnectionFactoryAdd();

    private ConnectionFactoryAdd() {
        super(ConnectionFactoryDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceName activeMQServiceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ConnectionFactoryConfiguration configuration = ConnectionFactoryAdd.createConfiguration(context, name, model);
        ConnectionFactoryService service = new ConnectionFactoryService(configuration);
        ServiceName serviceName = JMSServices.getConnectionFactoryBaseServiceName(activeMQServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, (Service)service).addDependency(ActiveMQActivationService.getServiceName(activeMQServiceName)).addDependency(JMSServices.getJmsManagerBaseServiceName(activeMQServiceName), JMSServerManager.class, service.getJmsServer()).setInitialMode(ServiceController.Mode.PASSIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.getExecutorInjector(), (boolean)false);
        serviceBuilder.install();
    }

    static ConnectionFactoryConfiguration createConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        ModelNode lbcn;
        List entries = ConnectionFactoryAttributes.Common.ENTRIES.unwrap((ExpressionResolver)context, model);
        ConnectionFactoryConfiguration config = new ConnectionFactoryConfigurationImpl().setName(name).setHA(false).setBindings(entries.toArray(new String[entries.size()]));
        config.setHA(CommonAttributes.HA.resolveModelAttribute(context, model).asBoolean());
        config.setAutoGroup(ConnectionFactoryAttributes.Common.AUTO_GROUP.resolveModelAttribute(context, model).asBoolean());
        config.setBlockOnAcknowledge(ConnectionFactoryAttributes.Common.BLOCK_ON_ACKNOWLEDGE.resolveModelAttribute(context, model).asBoolean());
        config.setBlockOnDurableSend(ConnectionFactoryAttributes.Common.BLOCK_ON_DURABLE_SEND.resolveModelAttribute(context, model).asBoolean());
        config.setBlockOnNonDurableSend(ConnectionFactoryAttributes.Common.BLOCK_ON_NON_DURABLE_SEND.resolveModelAttribute(context, model).asBoolean());
        config.setCacheLargeMessagesClient(ConnectionFactoryAttributes.Common.CACHE_LARGE_MESSAGE_CLIENT.resolveModelAttribute(context, model).asBoolean());
        config.setCallTimeout(CommonAttributes.CALL_TIMEOUT.resolveModelAttribute(context, model).asLong());
        config.setClientFailureCheckPeriod((long)ConnectionFactoryAttributes.Common.CLIENT_FAILURE_CHECK_PERIOD.resolveModelAttribute(context, model).asInt());
        config.setCallFailoverTimeout(CommonAttributes.CALL_FAILOVER_TIMEOUT.resolveModelAttribute(context, model).asLong());
        ModelNode clientId = CommonAttributes.CLIENT_ID.resolveModelAttribute(context, model);
        if (clientId.isDefined()) {
            config.setClientID(clientId.asString());
        }
        config.setCompressLargeMessages(ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES.resolveModelAttribute(context, model).asBoolean());
        config.setConfirmationWindowSize(ConnectionFactoryAttributes.Common.CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        config.setConnectionTTL(ConnectionFactoryAttributes.Common.CONNECTION_TTL.resolveModelAttribute(context, model).asLong());
        List connectorNames = ConnectionFactoryAttributes.Common.CONNECTORS.unwrap((ExpressionResolver)context, model);
        config.setConnectorNames(connectorNames);
        config.setConsumerMaxRate(ConnectionFactoryAttributes.Common.CONSUMER_MAX_RATE.resolveModelAttribute(context, model).asInt());
        config.setConsumerWindowSize(ConnectionFactoryAttributes.Common.CONSUMER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        ModelNode discoveryGroupName = ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.resolveModelAttribute(context, model);
        if (discoveryGroupName.isDefined()) {
            config.setDiscoveryGroupName(discoveryGroupName.asString());
        }
        config.setDupsOKBatchSize(ConnectionFactoryAttributes.Common.DUPS_OK_BATCH_SIZE.resolveModelAttribute(context, model).asInt());
        config.setFailoverOnInitialConnection(ConnectionFactoryAttributes.Common.FAILOVER_ON_INITIAL_CONNECTION.resolveModelAttribute(context, model).asBoolean());
        ModelNode groupId = ConnectionFactoryAttributes.Common.GROUP_ID.resolveModelAttribute(context, model);
        if (groupId.isDefined()) {
            config.setGroupID(groupId.asString());
        }
        if ((lbcn = ConnectionFactoryAttributes.Common.CONNECTION_LOAD_BALANCING_CLASS_NAME.resolveModelAttribute(context, model)).isDefined()) {
            config.setLoadBalancingPolicyClassName(lbcn.asString());
        }
        config.setMaxRetryInterval(ConnectionFactoryAttributes.Common.MAX_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong());
        config.setMinLargeMessageSize(ConnectionFactoryAttributes.Common.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(context, model).asInt());
        config.setPreAcknowledge(ConnectionFactoryAttributes.Common.PRE_ACKNOWLEDGE.resolveModelAttribute(context, model).asBoolean());
        config.setProducerMaxRate(ConnectionFactoryAttributes.Common.PRODUCER_MAX_RATE.resolveModelAttribute(context, model).asInt());
        config.setProducerWindowSize(ConnectionFactoryAttributes.Common.PRODUCER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        config.setReconnectAttempts(ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt());
        config.setRetryInterval(ConnectionFactoryAttributes.Common.RETRY_INTERVAL.resolveModelAttribute(context, model).asLong());
        config.setRetryIntervalMultiplier(ConnectionFactoryAttributes.Common.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(context, model).asDouble());
        config.setScheduledThreadPoolMaxSize(ConnectionFactoryAttributes.Common.SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        config.setThreadPoolMaxSize(ConnectionFactoryAttributes.Common.THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        config.setTransactionBatchSize(ConnectionFactoryAttributes.Common.TRANSACTION_BATCH_SIZE.resolveModelAttribute(context, model).asInt());
        config.setUseGlobalPools(ConnectionFactoryAttributes.Common.USE_GLOBAL_POOLS.resolveModelAttribute(context, model).asBoolean());
        config.setLoadBalancingPolicyClassName(ConnectionFactoryAttributes.Common.CONNECTION_LOAD_BALANCING_CLASS_NAME.resolveModelAttribute(context, model).asString());
        ModelNode clientProtocolManagerFactory = ConnectionFactoryAttributes.Common.PROTOCOL_MANAGER_FACTORY.resolveModelAttribute(context, model);
        if (clientProtocolManagerFactory.isDefined()) {
            config.setProtocolManagerFactoryStr(clientProtocolManagerFactory.asString());
        }
        JMSFactoryType jmsFactoryType = ConnectionFactoryType.valueOf(ConnectionFactoryAttributes.Regular.FACTORY_TYPE.resolveModelAttribute(context, model).asString()).getType();
        config.setFactoryType(jmsFactoryType);
        return config;
    }
}

