/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.BatcherFactory;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.clustering.infinispan.InfinispanBatcherFactory;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.CacheContainer;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;

@Listener
public class CacheContainerBuilder
implements ResourceServiceBuilder<CacheContainer> {
    private final List<ServiceName> aliases = new LinkedList<ServiceName>();
    private final PathAddress address;
    private final String name;
    private final BatcherFactory batcherFactory = new InfinispanBatcherFactory();
    private volatile String defaultCache;
    private volatile ValueDependency<GlobalConfiguration> configuration;

    public CacheContainerBuilder(PathAddress address) {
        this.address = address;
        this.name = address.getLastElement().getValue();
    }

    public ServiceName getServiceName() {
        return CacheContainerResourceDefinition.Capability.CONTAINER.getServiceName(this.address);
    }

    public CacheContainerBuilder configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.aliases.clear();
        ModelNodes.optionalList((ModelNode)CacheContainerResourceDefinition.Attribute.ALIASES.resolveModelAttribute((ExpressionResolver)context, model)).ifPresent(aliases -> aliases.stream().map(ModelNode::asString).forEach(alias -> this.aliases.add(InfinispanRequirement.CONTAINER.getServiceName(context.getCapabilityServiceSupport(), alias))));
        this.configuration = new InjectedValueDependency(InfinispanRequirement.CONFIGURATION.getServiceName(context, this.name), GlobalConfiguration.class);
        this.defaultCache = ModelNodes.optionalString((ModelNode)CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model)).orElse("___defaultcache");
        return this;
    }

    public ServiceBuilder<CacheContainer> build(ServiceTarget target) {
        Function<EmbeddedCacheManager, CacheContainer> mapper = manager -> new DefaultCacheContainer(this.name, (EmbeddedCacheManager)manager, this.defaultCache, this.batcherFactory);
        Supplier<EmbeddedCacheManager> supplier = () -> {
            GlobalConfiguration config = (GlobalConfiguration)this.configuration.getValue();
            DefaultCacheManager manager = new DefaultCacheManager(config, null, false);
            manager.addListener((Object)this);
            manager.start();
            InfinispanLogger.ROOT_LOGGER.debugf("%s cache container started", this.name);
            return manager;
        };
        Consumer<EmbeddedCacheManager> destroyer = manager -> {
            manager.stop();
            manager.removeListener((Object)this);
            InfinispanLogger.ROOT_LOGGER.debugf("%s cache container stopped", this.name);
        };
        SuppliedValueService service = new SuppliedValueService(mapper, supplier, destroyer);
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)service).addAliases((ServiceName[])this.aliases.stream().toArray(ServiceName[]::new)).setInitialMode(ServiceController.Mode.PASSIVE);
        return this.configuration.register(builder);
    }

    String getDefaultCache() {
        return this.defaultCache;
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStarted(event.getCacheName(), this.name);
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStopped(event.getCacheName(), this.name);
    }
}

