/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheBuilder;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class SharedStateCacheBuilder
extends ClusteredCacheBuilder {
    private final InjectedValue<PartitionHandlingConfiguration> partitionHandling = new InjectedValue();
    private final InjectedValue<StateTransferConfiguration> stateTransfer = new InjectedValue();
    private final InjectedValue<BackupForConfiguration> backupFor = new InjectedValue();
    private final InjectedValue<SitesConfiguration> backups = new InjectedValue();
    private final PathAddress address;

    SharedStateCacheBuilder(PathAddress address, CacheMode mode) {
        super(address, mode);
        this.address = address;
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.PARTITION_HANDLING.getServiceName(this.address), PartitionHandlingConfiguration.class, this.partitionHandling).addDependency(CacheComponent.STATE_TRANSFER.getServiceName(this.address), StateTransferConfiguration.class, this.stateTransfer).addDependency(CacheComponent.BACKUPS.getServiceName(this.address), SitesConfiguration.class, this.backups).addDependency(CacheComponent.BACKUP_FOR.getServiceName(this.address), BackupForConfiguration.class, this.backupFor);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        builder.clustering().partitionHandling().read((PartitionHandlingConfiguration)this.partitionHandling.getValue());
        builder.clustering().stateTransfer().read((StateTransferConfiguration)this.stateTransfer.getValue());
        SitesConfigurationBuilder sitesBuilder = builder.sites();
        sitesBuilder.read((SitesConfiguration)this.backups.getValue());
        sitesBuilder.backupFor().read((BackupForConfiguration)this.backupFor.getValue());
    }
}

