/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.ironjacamar;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.metadata.api.common.Credential;
import org.jboss.as.connector.metadata.api.common.Security;
import org.jboss.as.connector.metadata.common.CredentialImpl;
import org.jboss.as.connector.metadata.common.SecurityImpl;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ParserException;

public class IronJacamarParser
extends org.jboss.jca.common.metadata.ironjacamar.IronJacamarParser {
    protected Security parseSecuritySettings(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String securityDomain = null;
        Object securityDomainAndApplication = null;
        String authenticationContext = null;
        String authenticationContextAndApplication = null;
        boolean elytronEnabled = false;
        boolean application = Defaults.APPLICATION_MANAGED_SECURITY;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return new SecurityImpl(elytronEnabled ? authenticationContext : securityDomain, elytronEnabled ? authenticationContextAndApplication : securityDomainAndApplication, application, elytronEnabled);
                    }
                    if (Security.Tag.forName(reader.getLocalName()) != Security.Tag.UNKNOWN) break;
                    throw new ParserException("unexpectedEndTag(reader.getLocalName())");
                }
                case 1: {
                    switch (Security.Tag.forName(reader.getLocalName())) {
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        case ELYTRON_ENABLED: {
                            elytronEnabled = true;
                        }
                        case AUTHENTICATION_CONTEXT: {
                            authenticationContext = this.elementAsString(reader);
                            break block0;
                        }
                        case AUTHENTICATION_CONTEXT_AND_APPLICATION: {
                            authenticationContextAndApplication = this.elementAsString(reader);
                            break block0;
                        }
                        case APPLICATION: {
                            application = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("bundle.unexpectedElement(reader.getLocalName())");
                }
            }
        }
        throw new ParserException("bundle.unexpectedEndOfDocument()");
    }

    protected Credential parseCredential(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String securityDomain = null;
        boolean elytronEnabled = false;
        String authenticationContext = null;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return new CredentialImpl(userName, password, elytronEnabled ? authenticationContext : securityDomain, elytronEnabled, null);
                    }
                    if (Credential.Tag.forName(reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException("bundle.unexpectedEndTag(reader.getLocalName())");
                }
                case 1: {
                    switch (Credential.Tag.forName(reader.getLocalName())) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            break block0;
                        }
                        case USER_NAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        case ELYTRON_ENABLED: {
                            elytronEnabled = true;
                            break block0;
                        }
                        case AUTHENTICATION_CONTEXT: {
                            authenticationContext = this.elementAsString(reader);
                            break block0;
                        }
                    }
                    throw new ParserException("bundle.unexpectedElement(reader.getLocalName())");
                }
            }
        }
        throw new ParserException("bundle.unexpectedEndOfDocument()");
    }
}

