/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.Map;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;

public class ListOfConnectionsHandler
implements OperationStepHandler {
    public static final ListOfConnectionsHandler INSTANCE = new ListOfConnectionsHandler();

    private ListOfConnectionsHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode result = new ModelNode();
                    CachedConnectionManager ccm = (CachedConnectionManager)context.getServiceRegistry(false).getService(ConnectorServices.CCM_SERVICE).getValue();
                    Map map = ccm.listConnections();
                    ModelNode txResult = new ModelNode();
                    for (Map.Entry entry : map.entrySet()) {
                        txResult.add((String)entry.getKey(), (String)entry.getValue());
                    }
                    ccm = (CachedConnectionManager)context.getServiceRegistry(false).getService(ConnectorServices.NON_TX_CCM_SERVICE).getValue();
                    map = ccm.listConnections();
                    ModelNode nonTxResult = new ModelNode();
                    for (Map.Entry entry : map.entrySet()) {
                        nonTxResult.add((String)entry.getKey(), (String)entry.getValue());
                    }
                    result.get("TX").set(txResult);
                    result.get("NonTX").set(nonTxResult);
                    context.getResult().set(result);
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

