/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.io.IOException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3._private.IntIndexMap;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionService;
import org.wildfly.transaction.client.provider.remoting.TransactionServerChannel;

public final class RemotingTransactionServer {
    private final RemotingTransactionService transactionService;
    private final IntIndexMap<LocalTxn> txns = new IntIndexHashMap(LocalTxn::getId);

    RemotingTransactionServer(RemotingTransactionService transactionService, Connection connection) {
        this.transactionService = transactionService;
        connection.addCloseHandler(this::handleClosed);
    }

    @NotNull
    public LocalTransaction requireTransaction(int id) throws SystemException {
        LocalTxn txn = (LocalTxn)this.txns.get(id);
        if (txn == null) {
            throw Log.log.noTransactionForId(id);
        }
        return txn.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LocalTransaction getOrBeginTransaction(int id, int timeout) throws SystemException {
        LocalTxn txn = (LocalTxn)this.txns.get(id);
        if (txn != null) {
            return txn.getTransaction();
        }
        boolean ok = false;
        LocalTransaction transaction = this.transactionService.getTransactionContext().beginTransaction(timeout, true);
        try {
            LocalTxn appearing = (LocalTxn)this.txns.putIfAbsent((Object)new LocalTxn(id, transaction));
            if (appearing != null) {
                LocalTransaction localTransaction = appearing.getTransaction();
                return localTransaction;
            }
            ok = true;
            LocalTransaction localTransaction = transaction;
            return localTransaction;
        }
        finally {
            if (!ok) {
                RemotingTransactionServer.safeRollback(transaction);
            }
        }
    }

    public LocalTransaction getTransactionIfExists(int id) {
        LocalTxn txn = (LocalTxn)this.txns.get(id);
        return txn == null ? null : txn.getTransaction();
    }

    void handleClosed(Connection connection, IOException ignored) {
        for (LocalTxn txn : this.txns) {
            RemotingTransactionServer.safeRollback(txn.getTransaction());
        }
    }

    static void safeRollback(Transaction transaction) {
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (SystemException e) {
                Log.log.trace("Got exception during rollback-on-disconnect", e);
            }
        }
    }

    IntIndexMap<LocalTxn> getTxnMap() {
        return this.txns;
    }

    public RemotingTransactionService getTransactionService() {
        return this.transactionService;
    }

    TransactionServerChannel openChannel(Channel channel) {
        TransactionServerChannel transactionServerChannel = new TransactionServerChannel(this, channel, this.transactionService.getTransactionContext());
        transactionServerChannel.start();
        return transactionServerChannel;
    }

    static final class LocalTxn {
        private final LocalTransaction transaction;
        private final int id;

        LocalTxn(int id, LocalTransaction transaction) {
            this.id = id;
            this.transaction = transaction;
        }

        LocalTransaction getTransaction() {
            return this.transaction;
        }

        int getId() {
            return this.id;
        }
    }
}

