/*
 * Decompiled with CFR 0.152.
 */
package org.h2.api;

import java.io.Serializable;
import org.h2.util.DateTimeUtils;
import org.h2.util.StringUtils;

public class TimestampWithTimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4413229090646777107L;
    private final long dateValue;
    private final long timeNanos;
    private final short timeZoneOffsetMins;

    public TimestampWithTimeZone(long l, long l2, short s) {
        this.dateValue = l;
        this.timeNanos = l2;
        this.timeZoneOffsetMins = s;
    }

    public long getYMD() {
        return this.dateValue;
    }

    public int getYear() {
        return DateTimeUtils.yearFromDateValue(this.dateValue);
    }

    public int getMonth() {
        return DateTimeUtils.monthFromDateValue(this.dateValue);
    }

    public int getDay() {
        return DateTimeUtils.dayFromDateValue(this.dateValue);
    }

    public long getNanosSinceMidnight() {
        return this.timeNanos;
    }

    public short getTimeZoneOffsetMins() {
        return this.timeZoneOffsetMins;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = DateTimeUtils.yearFromDateValue(this.dateValue);
        int n3 = DateTimeUtils.monthFromDateValue(this.dateValue);
        int n4 = DateTimeUtils.dayFromDateValue(this.dateValue);
        if (n2 > 0 && n2 < 10000) {
            StringUtils.appendZeroPadded(stringBuilder, 4, n2);
        } else {
            stringBuilder.append(n2);
        }
        stringBuilder.append('-');
        StringUtils.appendZeroPadded(stringBuilder, 2, n3);
        stringBuilder.append('-');
        StringUtils.appendZeroPadded(stringBuilder, 2, n4);
        stringBuilder.append(' ');
        long l = this.timeNanos;
        long l2 = l / 1000000L;
        l -= l2 * 1000000L;
        long l3 = l2 / 1000L;
        l2 -= l3 * 1000L;
        long l4 = l3 / 60L;
        l3 -= l4 * 60L;
        long l5 = l4 / 60L;
        StringUtils.appendZeroPadded(stringBuilder, 2, l5);
        stringBuilder.append(':');
        StringUtils.appendZeroPadded(stringBuilder, 2, l4 -= l5 * 60L);
        stringBuilder.append(':');
        StringUtils.appendZeroPadded(stringBuilder, 2, l3);
        stringBuilder.append('.');
        int n5 = stringBuilder.length();
        StringUtils.appendZeroPadded(stringBuilder, 3, l2);
        if (l > 0L) {
            StringUtils.appendZeroPadded(stringBuilder, 6, l);
        }
        for (n = stringBuilder.length() - 1; n > n5 && stringBuilder.charAt(n) == '0'; --n) {
            stringBuilder.deleteCharAt(n);
        }
        n = this.timeZoneOffsetMins;
        if (n < 0) {
            stringBuilder.append('-');
            n = (short)(-n);
        } else {
            stringBuilder.append('+');
        }
        int n6 = n / 60;
        int n7 = n = (int)((short)(n - n6 * 60));
        StringUtils.appendZeroPadded(stringBuilder, 2, n6);
        if (n7 != 0) {
            stringBuilder.append(':');
            StringUtils.appendZeroPadded(stringBuilder, 2, n7);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.dateValue ^ this.dateValue >>> 32);
        n = 31 * n + (int)(this.timeNanos ^ this.timeNanos >>> 32);
        n = 31 * n + this.timeZoneOffsetMins;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TimestampWithTimeZone timestampWithTimeZone = (TimestampWithTimeZone)object;
        if (this.dateValue != timestampWithTimeZone.dateValue) {
            return false;
        }
        if (this.timeNanos != timestampWithTimeZone.timeNanos) {
            return false;
        }
        return this.timeZoneOffsetMins == timestampWithTimeZone.timeZoneOffsetMins;
    }
}

