/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import org.jboss.ejb.client.EJBInvocationHandler;
import org.jboss.ejb.client.EJBLocator;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.NamingProvider;

public final class SerializedEJBInvocationHandler
implements Externalizable {
    private static final long serialVersionUID = -2370168183054746652L;
    private EJBLocator<?> locator;
    private boolean async;

    public SerializedEJBInvocationHandler() {
    }

    public SerializedEJBInvocationHandler(EJBLocator<?> locator) {
        this.locator = locator;
        this.async = false;
    }

    public SerializedEJBInvocationHandler(EJBLocator<?> locator, boolean async) {
        this.locator = locator;
        this.async = async;
    }

    public EJBLocator<?> getLocator() {
        return this.locator;
    }

    public void setLocator(EJBLocator<?> locator) {
        Assert.checkNotNullParam((String)"locator", locator);
        this.locator = locator;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.locator);
        out.writeBoolean(this.async);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.locator = (EJBLocator)in.readObject();
        int data = in.read();
        if (data > 0) {
            this.async = true;
        }
    }

    protected Object readResolve() {
        EJBLocator<?> locator = this.locator;
        Assert.checkNotNullParam((String)"locator", locator);
        return SerializedEJBInvocationHandler.readResolve(locator);
    }

    private static <T> EJBInvocationHandler<T> readResolve(EJBLocator<T> locator) {
        NamingProvider namingProvider = NamingProvider.getCurrentNamingProvider();
        if (namingProvider != null) {
            URI providerUri = namingProvider.getProviderUri();
            if (providerUri.equals(locator.getAffinity().getUri())) {
                return new EJBInvocationHandler<T>(locator, namingProvider.getAuthenticationConfiguration(), namingProvider.getSSLContext());
            }
            return new EJBInvocationHandler<T>(locator, null, null);
        }
        return new EJBInvocationHandler<T>(locator, null, null);
    }
}

