/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.BridgeDefinition;
import org.wildfly.extension.messaging.activemq.ClusterConnectionDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.HTTPConnectorDefinition;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.MessagingSubsystemAdd;
import org.wildfly.extension.messaging.activemq.ServerDefinition;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeDefinition;

public class MessagingSubsystemRootResourceDefinition
extends PersistentResourceDefinition {
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-thread-pool-max-size", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setXmlName("thread-pool-max-size")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"global-client-scheduled-thread-pool-max-size", (ModelType)ModelType.INT).setAttributeGroup("global-client")).setXmlName("scheduled-thread-pool-max-size")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{GLOBAL_CLIENT_THREAD_POOL_MAX_SIZE, GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_MAX_SIZE};
    public static final MessagingSubsystemRootResourceDefinition INSTANCE = new MessagingSubsystemRootResourceDefinition();

    private MessagingSubsystemRootResourceDefinition() {
        super(MessagingExtension.SUBSYSTEM_PATH, MessagingExtension.getResourceDescriptionResolver("messaging-activemq"), (OperationStepHandler)MessagingSubsystemAdd.INSTANCE, (OperationStepHandler)new ReloadRequiredRemoveStepHandler(){

            protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
                super.performRuntime(context, operation, model);
                context.removeService(MessagingServices.ACTIVEMQ_CLIENT_THREAD_POOL);
            }
        });
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public static void registerTransformers(SubsystemRegistration subsystemRegistration) {
        MessagingSubsystemRootResourceDefinition.registerTransformers_EAP_7_0_0(subsystemRegistration);
    }

    private static void registerTransformers_EAP_7_0_0(SubsystemRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder subsystem = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(subsystem, new AttributeDefinition[]{GLOBAL_CLIENT_THREAD_POOL_MAX_SIZE, GLOBAL_CLIENT_SCHEDULED_THREAD_POOL_MAX_SIZE});
        ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(MessagingExtension.SERVER_PATH);
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(server, new AttributeDefinition[]{ServerDefinition.ELYTRON_DOMAIN, ServerDefinition.JOURNAL_DATASOURCE, ServerDefinition.JOURNAL_MESSAGES_TABLE, ServerDefinition.JOURNAL_BINDINGS_TABLE, ServerDefinition.JOURNAL_JMS_BINDINGS_TABLE, ServerDefinition.JOURNAL_LARGE_MESSAGES_TABLE, ServerDefinition.JOURNAL_PAGE_STORE_TABLE, ServerDefinition.JOURNAL_DATABASE, ServerDefinition.JOURNAL_JDBC_NETWORK_TIMEOUT});
        ((AttributeTransformationDescriptionBuilder)server.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{ServerDefinition.CREDENTIAL_REFERENCE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ServerDefinition.CREDENTIAL_REFERENCE});
        ResourceTransformationDescriptionBuilder replicationMaster = server.addChildResource(MessagingExtension.REPLICATION_MASTER_PATH);
        replicationMaster.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{HAAttributes.CHECK_FOR_LIVE_SERVER});
        ResourceTransformationDescriptionBuilder replicationColocated = server.addChildResource(MessagingExtension.REPLICATION_COLOCATED_PATH);
        ResourceTransformationDescriptionBuilder masterForReplicationColocated = replicationColocated.addChildResource(MessagingExtension.CONFIGURATION_MASTER_PATH);
        masterForReplicationColocated.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{HAAttributes.CHECK_FOR_LIVE_SERVER});
        ResourceTransformationDescriptionBuilder bridge = server.addChildResource(MessagingExtension.BRIDGE_PATH);
        ((AttributeTransformationDescriptionBuilder)bridge.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{BridgeDefinition.CREDENTIAL_REFERENCE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{BridgeDefinition.CREDENTIAL_REFERENCE});
        ResourceTransformationDescriptionBuilder httpConnector = server.addChildResource(MessagingExtension.HTTP_CONNECTOR_PATH);
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(httpConnector, new AttributeDefinition[]{HTTPConnectorDefinition.SERVER_NAME});
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(bridge, new AttributeDefinition[]{BridgeDefinition.PRODUCER_WINDOW_SIZE});
        ResourceTransformationDescriptionBuilder jmsBridge = server.addChildResource(MessagingExtension.JMS_BRIDGE_PATH);
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(jmsBridge, new AttributeDefinition[]{JMSBridgeDefinition.SOURCE_CREDENTIAL_REFERENCE});
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(jmsBridge, new AttributeDefinition[]{JMSBridgeDefinition.TARGET_CREDENTIAL_REFERENCE});
        ResourceTransformationDescriptionBuilder clusterConnection = server.addChildResource(MessagingExtension.CLUSTER_CONNECTION_PATH);
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(clusterConnection, new AttributeDefinition[]{ClusterConnectionDefinition.PRODUCER_WINDOW_SIZE});
        ResourceTransformationDescriptionBuilder connectionFactory = server.addChildResource(MessagingExtension.CONNECTION_FACTORY_PATH);
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(connectionFactory, new AttributeDefinition[]{ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST});
        MessagingSubsystemRootResourceDefinition.defaultValueAttributeConverter(connectionFactory, (AttributeDefinition)CommonAttributes.CALL_FAILOVER_TIMEOUT);
        ResourceTransformationDescriptionBuilder pooledConnectionFactory = server.addChildResource(MessagingExtension.POOLED_CONNECTION_FACTORY_PATH);
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(pooledConnectionFactory, new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.REBALANCE_CONNECTIONS});
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(pooledConnectionFactory, new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.STATISTICS_ENABLED});
        MessagingSubsystemRootResourceDefinition.defaultValueAttributeConverter(pooledConnectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE);
        MessagingSubsystemRootResourceDefinition.defaultValueAttributeConverter(pooledConnectionFactory, (AttributeDefinition)CommonAttributes.CALL_FAILOVER_TIMEOUT);
        MessagingSubsystemRootResourceDefinition.defaultValueAttributeConverter(pooledConnectionFactory, (AttributeDefinition)ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE);
        MessagingSubsystemRootResourceDefinition.rejectDefinedAttributeWithDefaultValue(pooledConnectionFactory, new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.CREDENTIAL_REFERENCE, ConnectionFactoryAttributes.Common.DESERIALIZATION_BLACKLIST, ConnectionFactoryAttributes.Common.DESERIALIZATION_WHITELIST, ConnectionFactoryAttributes.Pooled.ALLOW_LOCAL_TRANSACTIONS});
        TransformationDescription.Tools.register((TransformationDescription)subsystem.build(), (SubsystemRegistration)subsystemRegistration, (ModelVersionRange)MessagingExtension.VERSION_1_0_0);
    }

    private static void rejectDefinedAttributeWithDefaultValue(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        for (AttributeDefinition attr : attrs) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{attr.getDefaultValue()}), new AttributeDefinition[]{attr})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{attr});
        }
    }

    private static void rejectDefinedAttribute(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        for (AttributeDefinition attr : attrs) {
            builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{attr});
        }
    }

    private static void defaultValueAttributeConverter(ResourceTransformationDescriptionBuilder builder, AttributeDefinition attr) {
        builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(attr), new AttributeDefinition[]{attr});
    }
}

