/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.weld._private.WeldEjbLogger;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.as.weld.ejb.SerializedStatefulSessionObject;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.ejb.client.SessionID;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.api.SessionObjectReference;

public class StatefulSessionObjectReferenceImpl
implements SessionObjectReference,
Serializable {
    private volatile boolean removed = false;
    private final ServiceName createServiceName;
    private final SessionID id;
    private final StatefulSessionComponent ejbComponent;
    private final Map<Class<?>, ServiceName> viewServices;
    private transient Map<String, ManagedReference> businessInterfaceToReference;

    public StatefulSessionObjectReferenceImpl(SessionID id, ServiceName createServiceName, Map<Class<?>, ServiceName> viewServices) {
        this.id = id;
        this.createServiceName = createServiceName;
        this.viewServices = viewServices;
        ServiceController controller = StatefulSessionObjectReferenceImpl.currentServiceContainer().getRequiredService(createServiceName);
        this.ejbComponent = (StatefulSessionComponent)controller.getValue();
    }

    public StatefulSessionObjectReferenceImpl(EjbDescriptorImpl<?> descriptor) {
        this.createServiceName = descriptor.getCreateServiceName();
        ServiceController controller = StatefulSessionObjectReferenceImpl.currentServiceContainer().getRequiredService(this.createServiceName);
        this.ejbComponent = (StatefulSessionComponent)controller.getValue();
        this.id = this.ejbComponent.createSession();
        this.viewServices = descriptor.getViewServices();
    }

    public synchronized <S> S getBusinessObject(Class<S> businessInterfaceType) {
        if (this.isRemoved()) {
            WeldEjbLogger.ROOT_LOGGER.ejbHashBeenRemoved(this.ejbComponent);
        }
        String businessInterfaceName = businessInterfaceType.getName();
        ManagedReference managedReference = null;
        if (this.businessInterfaceToReference == null) {
            this.businessInterfaceToReference = new HashMap<String, ManagedReference>();
        } else {
            managedReference = this.businessInterfaceToReference.get(businessInterfaceName);
        }
        if (managedReference == null) {
            if (this.viewServices.containsKey(businessInterfaceType)) {
                ServiceController serviceController = StatefulSessionObjectReferenceImpl.currentServiceContainer().getRequiredService(this.viewServices.get(businessInterfaceType));
                ComponentView view = (ComponentView)serviceController.getValue();
                try {
                    managedReference = view.createInstance(Collections.singletonMap(SessionID.class, this.id));
                    this.businessInterfaceToReference.put(businessInterfaceName, managedReference);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw WeldLogger.ROOT_LOGGER.viewNotFoundOnEJB(businessInterfaceType.getName(), this.ejbComponent.getComponentName());
            }
        }
        return (S)managedReference.getInstance();
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    protected Object writeReplace() throws IOException {
        return new SerializedStatefulSessionObject(this.createServiceName, this.id, this.viewServices);
    }

    public void remove() {
        if (!this.isRemoved()) {
            this.ejbComponent.removeSession(this.id);
            this.removed = true;
        }
    }

    public boolean isRemoved() {
        if (!this.removed) {
            Cache cache = this.ejbComponent.getCache();
            if (cache == null) {
                return true;
            }
            return !cache.contains((Object)this.id);
        }
        return true;
    }
}

