/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.infinispan.configuration.cache.CacheMode;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.CacheBuilderProvider;
import org.wildfly.clustering.spi.DistributedCacheBuilderProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorBuilder;
import org.wildfly.clustering.web.infinispan.session.RouteRegistryEntryProviderBuilder;
import org.wildfly.clustering.web.session.RouteLocator;
import org.wildfly.clustering.web.session.RouteLocatorBuilderProvider;

public class InfinispanRouteLocatorBuilderProvider
implements RouteLocatorBuilderProvider {
    public CapabilityServiceBuilder<RouteLocator> getRouteLocatorBuilder(String serverName, String deploymentName) {
        return new InfinispanRouteLocatorBuilder(serverName, deploymentName);
    }

    public Collection<CapabilityServiceBuilder<?>> getRouteLocatorConfigurationBuilders(String serverName, Supplier<ValueDependency<String>> routeDependencyProvider) {
        String containerName = "web";
        LinkedList builders = new LinkedList();
        builders.add(new RouteRegistryEntryProviderBuilder(serverName, routeDependencyProvider.get()));
        builders.add((CapabilityServiceBuilder<?>)new TemplateConfigurationBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, serverName)), containerName, serverName, null, builder -> {
            CacheMode mode = builder.clustering().cacheMode();
            builder.clustering().cacheMode(mode.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
            builder.clustering().l1().disable();
            builder.persistence().clearStores();
        }));
        builders.add((CapabilityServiceBuilder<?>)new CacheBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(containerName, serverName)), containerName, serverName));
        ServiceNameRegistry registry = requirement -> ServiceName.parse((String)requirement.resolve(containerName, serverName));
        for (CacheBuilderProvider cacheBuilderProvider : ServiceLoader.load(DistributedCacheBuilderProvider.class, DistributedCacheBuilderProvider.class.getClassLoader())) {
            builders.addAll(cacheBuilderProvider.getBuilders(registry, containerName, serverName));
        }
        return builders;
    }
}

