/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.jboss.wsf.stack.cxf.addons.transports.udp.UDPDestination;

public class UDPConduit
extends AbstractConduit {
    private static final String MULTI_RESPONSE_TIMEOUT = "udp.multi.response.timeout";
    private static final Logger LOG = LogUtils.getL7dLogger(UDPDestination.class);
    Bus bus;

    public UDPConduit(EndpointReferenceType t, Bus bus) {
        super(t);
        this.bus = bus;
    }

    private void dataReceived(Message message, byte[] bytes, boolean async) {
        MessageImpl inMessage = new MessageImpl();
        inMessage.setExchange(message.getExchange());
        message.getExchange().setInMessage((Message)inMessage);
        inMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream(bytes));
        this.incomingObserver.onMessage((Message)inMessage);
        if (!message.getExchange().isSynchronous()) {
            message.getExchange().setInMessage(null);
        }
    }

    public void prepare(Message message) throws IOException {
        try {
            URI uri;
            String address = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
            if (StringUtils.isEmpty((String)address)) {
                address = this.getTarget().getAddress().getValue();
            }
            if (StringUtils.isEmpty((String)(uri = new URI(address)).getHost())) {
                String s = uri.getSchemeSpecificPart();
                if (s.startsWith("//:")) {
                    s = s.substring(3);
                }
                if (s.indexOf(47) != -1) {
                    s = s.substring(0, s.indexOf(47));
                }
                int port = Integer.parseInt(s);
                this.send(message, null, port);
            } else {
                InetSocketAddress isa = new InetSocketAddress(uri.getHost(), uri.getPort());
                this.send(message, isa, isa.getPort());
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private void send(Message message, InetSocketAddress isa, int port) {
        message.setContent(OutputStream.class, (Object)new SocketOutputStream(port, isa, message));
    }

    protected Logger getLogger() {
        return LOG;
    }

    private final class SocketOutputStream
    extends LoadingByteArrayOutputStream {
        private final int port;
        private final Message message;
        private final InetSocketAddress isa;

        private SocketOutputStream(int port, InetSocketAddress isa, Message message) {
            this.port = port;
            this.message = message;
            this.isa = isa;
        }

        public void close() throws IOException {
            DatagramSocket socket;
            block17: {
                super.close();
                socket = this.isa != null ? new MulticastSocket(null) : new DatagramSocket();
                socket.setSendBufferSize(this.size());
                socket.setReceiveBufferSize(65536);
                socket.setBroadcast(true);
                if (this.isa == null) {
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface networkInterface = interfaces.nextElement();
                        if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                        for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                            InetAddress broadcast = interfaceAddress.getBroadcast();
                            if (broadcast == null) continue;
                            DatagramPacket sendPacket = new DatagramPacket(this.getRawBytes(), 0, this.size(), broadcast, this.port);
                            try {
                                socket.send(sendPacket);
                            }
                            catch (Exception e) {
                                LOG.log(Level.FINEST, e.getMessage(), e);
                            }
                        }
                    }
                } else {
                    DatagramPacket sendPacket = new DatagramPacket(this.getRawBytes(), 0, this.size(), this.isa);
                    try {
                        socket.send(sendPacket);
                    }
                    catch (Exception e) {
                        LOG.log(Level.FINEST, e.getMessage(), e);
                    }
                }
                if (!this.message.getExchange().isOneWay()) {
                    byte[] bytes = new byte[65536];
                    DatagramPacket p = new DatagramPacket(bytes, bytes.length);
                    Object to = this.message.getContextualProperty(UDPConduit.MULTI_RESPONSE_TIMEOUT);
                    Integer i = null;
                    if (to instanceof String) {
                        i = Integer.parseInt((String)to);
                    } else if (to instanceof Integer) {
                        i = (Integer)to;
                    }
                    if (i == null || i <= 0 || this.message.getExchange().isSynchronous()) {
                        socket.setSoTimeout(30000);
                        socket.receive(p);
                        UDPConduit.this.dataReceived(this.message, bytes, false);
                    } else {
                        socket.setSoTimeout(i);
                        boolean found = false;
                        try {
                            while (true) {
                                socket.receive(p);
                                UDPConduit.this.dataReceived(this.message, bytes, false);
                                found = true;
                            }
                        }
                        catch (SocketTimeoutException ex) {
                            if (found) break block17;
                            throw ex;
                        }
                    }
                }
            }
            socket.close();
        }
    }
}

