/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.password.CompoundRestriction;
import org.jboss.as.domain.management.security.password.Dictionary;
import org.jboss.as.domain.management.security.password.Keyboard;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordStrengthCheckResult;
import org.jboss.as.domain.management.security.password.PasswordStrengthChecker;
import org.jboss.as.domain.management.security.password.PasswordValidationException;
import org.jboss.as.domain.management.security.password.RegexRestriction;
import org.jboss.as.domain.management.security.password.simple.SimpleDictionary;
import org.jboss.as.domain.management.security.password.simple.SimpleKeyboard;
import org.jboss.as.domain.management.security.password.simple.SimplePasswordStrengthCheckResult;

public class SimplePasswordStrengthChecker
implements PasswordStrengthChecker {
    public static final String REGEX_DIGITS = "[0-9]";
    public static final String REGEX_SYMBOLS = "[^0-9a-zA-Z]";
    public static final String REGEX_ALPHA_UC = "[A-Z]";
    public static final String REGEX_ALPHA_LC = "[a-z]";
    public static final String REGEX_ALPHA = "[a-zA-Z]";
    protected static final int PWD_LEN_WEIGHT = 2;
    protected static final int REQUIREMENTS_WEIGHT = 10;
    protected static final int SYMBOLS_WEIGHT = 6;
    protected static final int DIGITS_WEIGHT = 4;
    protected static final int MIDDLE_NONCHAR_WEIGHT = 2;
    protected static final int ALPHA_WEIGHT = 2;
    protected static final int ALPHA_ONLY_WEIGHT = 2;
    protected static final int DIGITS_ONLY_WEIGHT = 4;
    protected static final int CONSECUTIVE_ALPHA_WEIGHT = 2;
    protected static final int CONSECUTIVE_DIGITS_WEIGHT = 2;
    protected static final int CONSECUTIVE_SYMBOLS_WEIGHT = 2;
    protected static final int DICTIONARY_WORD_WEIGHT = 1;
    protected static final int SEQUENTIAL_WEIGHT = 3;
    private String userName;
    private String password;
    private int passwordLength;
    private final List<PasswordRestriction> restrictionsInPlace;
    private final Dictionary dictionary;
    private final Keyboard keyboard;
    private List<PasswordRestriction> adHocRestrictions;
    private SimplePasswordStrengthCheckResult result;

    public SimplePasswordStrengthChecker() {
        this.restrictionsInPlace = new ArrayList<PasswordRestriction>();
        this.dictionary = new SimpleDictionary();
        this.keyboard = new SimpleKeyboard();
    }

    public SimplePasswordStrengthChecker(List<PasswordRestriction> initRestrictions, Dictionary dictionary, Keyboard keyboard) {
        if (initRestrictions == null) {
            throw new IllegalArgumentException("Initial restrictions must not be null.");
        }
        this.restrictionsInPlace = Collections.unmodifiableList(initRestrictions);
        this.dictionary = dictionary;
        this.keyboard = keyboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PasswordStrengthCheckResult check(String userName, String password, List<PasswordRestriction> restictions) {
        try {
            this.userName = userName;
            this.password = password;
            this.passwordLength = this.password.length();
            this.adHocRestrictions = restictions;
            this.result = new SimplePasswordStrengthCheckResult();
            this.checkRestrictions();
            this.result.positive(password.length() * 2);
            this.checkSymbols();
            this.checkDigits();
            this.checkMiddleNonChar();
            this.checkAlpha();
            this.checkAlphaOnly();
            this.checkNumbersOnly();
            this.checkConsecutiveAlpha();
            this.checkConsecutiveNumbers();
            this.checkConsecutiveSymbols();
            this.checkSequential();
            this.result.calculateStrength();
        }
        finally {
            this.password = null;
            this.passwordLength = 0;
            this.adHocRestrictions = null;
        }
        return this.result;
    }

    protected void checkRestrictions() {
        int met = 0;
        if (this.adHocRestrictions != null) {
            for (PasswordRestriction pr : this.adHocRestrictions) {
                if (pr instanceof CompoundRestriction) {
                    for (PasswordRestriction wrapped : ((CompoundRestriction)pr).getRestrictions()) {
                        try {
                            wrapped.validate(this.userName, this.password);
                            this.result.addPassedRestriction(wrapped);
                            ++met;
                        }
                        catch (PasswordValidationException pve) {
                            this.result.addRestrictionFailure(pve);
                        }
                    }
                    continue;
                }
                try {
                    pr.validate(this.userName, this.password);
                    this.result.addPassedRestriction(pr);
                    ++met;
                }
                catch (PasswordValidationException pve) {
                    this.result.addRestrictionFailure(pve);
                }
            }
        }
        for (PasswordRestriction pr : this.restrictionsInPlace) {
            if (pr instanceof CompoundRestriction) {
                for (PasswordRestriction wrapped : ((CompoundRestriction)pr).getRestrictions()) {
                    try {
                        wrapped.validate(this.userName, this.password);
                        this.result.addPassedRestriction(wrapped);
                        ++met;
                    }
                    catch (PasswordValidationException pve) {
                        this.result.addRestrictionFailure(pve);
                    }
                }
                continue;
            }
            try {
                pr.validate(this.userName, this.password);
                this.result.addPassedRestriction(pr);
                ++met;
            }
            catch (PasswordValidationException pve) {
                this.result.addRestrictionFailure(pve);
            }
        }
        this.result.positive(met * 10);
    }

    protected void checkSymbols() {
        int met = 0;
        Pattern symbolsPatter = Pattern.compile("[^0-9a-zA-Z]?");
        Matcher matcher = symbolsPatter.matcher(this.password);
        while (matcher.find()) {
            int end;
            int start = matcher.start();
            if (start == (end = matcher.end())) continue;
            ++met;
        }
        this.result.positive(met * 10);
    }

    protected void checkDigits() {
        int met = 0;
        Pattern symbolsPatter = Pattern.compile("[0-9]?");
        Matcher matcher = symbolsPatter.matcher(this.password);
        while (matcher.find()) {
            int end;
            int start = matcher.start();
            if (start == (end = matcher.end())) continue;
            ++met;
        }
        this.result.positive(met * 4);
    }

    protected void checkMiddleNonChar() {
        int met = 0;
        Pattern symbolsPatter = Pattern.compile("[^0-9a-zA-Z]?");
        Matcher matcher = symbolsPatter.matcher(this.password);
        while (matcher.find()) {
            int end;
            int start = matcher.start();
            if (start == (end = matcher.end()) && start != 0 && end != this.passwordLength) continue;
            ++met;
        }
        this.result.positive(met * 2);
    }

    protected void checkAlpha() {
        int end;
        int start;
        int met = 0;
        Pattern symbolsPatter = Pattern.compile("[A-Z]?");
        Matcher matcher = symbolsPatter.matcher(this.password);
        while (matcher.find()) {
            start = matcher.start();
            if (start == (end = matcher.end())) continue;
            ++met;
        }
        met = 0;
        symbolsPatter = Pattern.compile("[a-z]?");
        matcher = symbolsPatter.matcher(this.password);
        while (matcher.find()) {
            start = matcher.start();
            if (start == (end = matcher.end())) continue;
            ++met;
        }
        this.result.positive((this.passwordLength - met) * 2);
    }

    protected void checkAlphaOnly() {
        Pattern symbolsPatter = Pattern.compile("[a-zA-Z]*");
        Matcher matcher = symbolsPatter.matcher(this.password);
        if (matcher.find() && matcher.end() == this.passwordLength) {
            this.result.negative(this.passwordLength * 2);
        }
    }

    protected void checkNumbersOnly() {
        Pattern symbolsPatter = Pattern.compile("[0-9]*");
        Matcher matcher = symbolsPatter.matcher(this.password);
        if (matcher.find() && matcher.end() == this.passwordLength) {
            this.result.negative(this.passwordLength * 4);
        }
    }

    protected void checkConsecutiveAlpha() {
        int diff;
        int end;
        int start;
        Pattern symbolsPatter = Pattern.compile("[A-Z]+");
        Matcher matcher = symbolsPatter.matcher(this.password);
        int met = 0;
        while (matcher.find()) {
            start = matcher.start();
            if (start == (end = matcher.end()) || (diff = end - start) < 3) continue;
            met += diff;
        }
        this.result.negative(met * 2);
        symbolsPatter = Pattern.compile("[a-z]+");
        matcher = symbolsPatter.matcher(this.password);
        met = 0;
        while (matcher.find()) {
            start = matcher.start();
            if (start == (end = matcher.end()) || (diff = end - start) < 3) continue;
            met += diff;
        }
        this.result.negative(met * 2);
    }

    protected void checkConsecutiveNumbers() {
        Pattern symbolsPatter = Pattern.compile("[0-9]+");
        Matcher matcher = symbolsPatter.matcher(this.password);
        int met = 0;
        while (matcher.find()) {
            int diff;
            int end;
            int start = matcher.start();
            if (start == (end = matcher.end()) || (diff = end - start) < 3) continue;
            met += diff;
        }
        this.result.negative(met * 2);
    }

    protected void checkConsecutiveSymbols() {
        Pattern symbolsPatter = Pattern.compile("[^0-9a-zA-Z]+");
        Matcher matcher = symbolsPatter.matcher(this.password);
        int met = 0;
        while (matcher.find()) {
            int diff;
            int end;
            int start = matcher.start();
            if (start == (end = matcher.end()) || (diff = end - start) < 3) continue;
            met += diff;
        }
        this.result.negative(met * 2);
    }

    protected void checkSequential() {
        int chainSize = 0;
        for (int index = 0; index < this.passwordLength - 1; ++index) {
            if (!this.keyboard.siblings(this.password, index)) continue;
            chainSize += this.keyboard.sequence(this.password, index);
        }
        if (chainSize > 0) {
            this.result.negative(chainSize * 3);
        }
    }

    protected void checkDictionary() {
        int score;
        if (this.dictionary != null && (score = this.dictionary.dictionarySequence(this.password)) > 0) {
            this.result.negative(score * 1);
        }
    }

    public static PasswordRestriction getRestrictionAlpha(int minAlpha) {
        return SimplePasswordStrengthChecker.createRegExRestriction(minAlpha, REGEX_ALPHA, DomainManagementLogger.ROOT_LOGGER.passwordMustHaveAlphaInfo(minAlpha), DomainManagementLogger.ROOT_LOGGER.passwordMustHaveAlpha(minAlpha));
    }

    public static PasswordRestriction getRestrictionDigit(int minDigit) {
        return SimplePasswordStrengthChecker.createRegExRestriction(minDigit, REGEX_DIGITS, DomainManagementLogger.ROOT_LOGGER.passwordMustHaveDigitInfo(minDigit), DomainManagementLogger.ROOT_LOGGER.passwordMustHaveDigit(minDigit));
    }

    public static PasswordRestriction getRestrictionSymbol(int minSymbol) {
        return SimplePasswordStrengthChecker.createRegExRestriction(minSymbol, REGEX_SYMBOLS, DomainManagementLogger.ROOT_LOGGER.passwordMustHaveSymbolInfo(minSymbol), DomainManagementLogger.ROOT_LOGGER.passwordMustHaveSymbol(minSymbol));
    }

    private static PasswordRestriction createRegExRestriction(int minChar, String regex, String requirementsMessage, String failureMessage) {
        if (minChar > 0) {
            return new RegexRestriction(String.format("(.*%s.*){%d}", REGEX_ALPHA, minChar), requirementsMessage, failureMessage);
        }
        return new PasswordRestriction(){

            @Override
            public void validate(String userName, String password) throws PasswordValidationException {
            }

            @Override
            public String getRequirementMessage() {
                return "";
            }
        };
    }
}

