/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.api.functional.EntryVersion;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;

public final class MetaParamExternalizers {
    private MetaParamExternalizers() {
    }

    public static final class NumericEntryVersionExternalizer
    extends AbstractExternalizer<EntryVersion.NumericEntryVersion> {
        public void writeObject(ObjectOutput output, EntryVersion.NumericEntryVersion object) throws IOException {
            output.writeLong(object.get());
        }

        public EntryVersion.NumericEntryVersion readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            long version = input.readLong();
            return new EntryVersion.NumericEntryVersion(version);
        }

        public Set<Class<? extends EntryVersion.NumericEntryVersion>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{EntryVersion.NumericEntryVersion.class});
        }

        public Integer getId() {
            return 156;
        }
    }

    public static final class EntryVersionParamExternalizer
    extends AbstractExternalizer<MetaParam.MetaEntryVersion> {
        public void writeObject(ObjectOutput output, MetaParam.MetaEntryVersion object) throws IOException {
            output.writeObject(object.get());
        }

        public MetaParam.MetaEntryVersion readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            EntryVersion entryVersion = (EntryVersion)input.readObject();
            return new MetaParam.MetaEntryVersion(entryVersion);
        }

        public Set<Class<? extends MetaParam.MetaEntryVersion>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MetaParam.MetaEntryVersion.class});
        }

        public Integer getId() {
            return 155;
        }
    }

    public static final class LifespanExternalizer
    extends AbstractExternalizer<MetaParam.MetaLifespan> {
        public void writeObject(ObjectOutput output, MetaParam.MetaLifespan object) throws IOException {
            output.writeLong(object.get());
        }

        public MetaParam.MetaLifespan readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new MetaParam.MetaLifespan(input.readLong());
        }

        public Set<Class<? extends MetaParam.MetaLifespan>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MetaParam.MetaLifespan.class});
        }

        public Integer getId() {
            return 154;
        }
    }
}

