/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.infinispan.configuration.cache.CacheMode;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.spi.CacheAliasBuilderProvider;
import org.wildfly.clustering.spi.CacheBuilderProvider;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class ClientMappingsCacheBuilderProvider
implements CacheBuilderProvider,
CacheAliasBuilderProvider {
    private final Class<? extends CacheBuilderProvider> providerClass;

    ClientMappingsCacheBuilderProvider(Class<? extends CacheBuilderProvider> providerClass) {
        this.providerClass = providerClass;
    }

    public Collection<CapabilityServiceBuilder<?>> getBuilders(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String aliasCacheName) {
        LinkedList builders = new LinkedList();
        if (aliasCacheName == null) {
            String cacheName = "client-mappings";
            builders.add((CapabilityServiceBuilder<?>)new TemplateConfigurationBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, cacheName)), containerName, cacheName, aliasCacheName, builder -> {
                CacheMode mode = builder.clustering().cacheMode();
                builder.clustering().cacheMode(mode.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
                builder.clustering().l1().disable();
                builder.persistence().clearStores();
            }));
            builders.add((CapabilityServiceBuilder<?>)new CacheBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(containerName, cacheName)), containerName, cacheName));
            ServiceNameRegistry routingRegistry = requirement -> ServiceName.parse((String)requirement.resolve(containerName, cacheName));
            for (CacheBuilderProvider cacheBuilderProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
                builders.addAll(cacheBuilderProvider.getBuilders(routingRegistry, containerName, cacheName));
            }
        }
        return builders;
    }

    public Collection<CapabilityServiceBuilder<?>> getBuilders(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String aliasCacheName, String targetCacheName) {
        return this.getBuilders(registry, containerName, aliasCacheName);
    }
}

