/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.OperationDefinitionHelper;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public abstract class AbstractQueueControlHandler<T>
extends AbstractRuntimeOnlyHandler {
    private static ResourceDescriptionResolver RESOLVER = MessagingExtension.getResourceDescriptionResolver("queue");
    public static final String LIST_MESSAGES = "list-messages";
    public static final String LIST_MESSAGES_AS_JSON = "list-messages-as-json";
    public static final String COUNT_MESSAGES = "count-messages";
    public static final String REMOVE_MESSAGE = "remove-message";
    public static final String REMOVE_MESSAGES = "remove-messages";
    public static final String EXPIRE_MESSAGES = "expire-messages";
    public static final String EXPIRE_MESSAGE = "expire-message";
    public static final String SEND_MESSAGE_TO_DEAD_LETTER_ADDRESS = "send-message-to-dead-letter-address";
    public static final String SEND_MESSAGES_TO_DEAD_LETTER_ADDRESS = "send-messages-to-dead-letter-address";
    public static final String CHANGE_MESSAGE_PRIORITY = "change-message-priority";
    public static final String CHANGE_MESSAGES_PRIORITY = "change-messages-priority";
    public static final String MOVE_MESSAGE = "move-message";
    public static final String MOVE_MESSAGES = "move-messages";
    public static final String LIST_MESSAGE_COUNTER = "list-message-counter";
    public static final String LIST_MESSAGE_COUNTER_AS_JSON = "list-message-counter-as-json";
    public static final String LIST_MESSAGE_COUNTER_AS_HTML = "list-message-counter-as-html";
    public static final String RESET_MESSAGE_COUNTER = "reset-message-counter";
    public static final String LIST_MESSAGE_COUNTER_HISTORY = "list-message-counter-history";
    public static final String LIST_MESSAGE_COUNTER_HISTORY_AS_JSON = "list-message-counter-history-as-json";
    public static final String LIST_MESSAGE_COUNTER_HISTORY_AS_HTML = "list-message-counter-history-as-html";
    public static final String PAUSE = "pause";
    public static final String RESUME = "resume";
    public static final String LIST_CONSUMERS = "list-consumers";
    public static final String LIST_CONSUMERS_AS_JSON = "list-consumers-as-json";
    public static final String LIST_SCHEDULED_MESSAGES = "list-scheduled-messages";
    public static final String LIST_SCHEDULED_MESSAGES_AS_JSON = "list-scheduled-messages-as-json";
    public static final String LIST_DELIVERING_MESSAGES = "list-delivering-messages";
    public static final String LIST_DELIVERING_MESSAGES_AS_JSON = "list-delivering-messages-as-json";
    public static final ParameterValidator PRIORITY_VALIDATOR = new IntRangeValidator(0, 9, false, false);
    private static final AttributeDefinition OTHER_QUEUE_NAME = OperationDefinitionHelper.createNonEmptyStringAttribute("other-queue-name");
    private static final AttributeDefinition REJECT_DUPLICATES = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reject-duplicates", (ModelType)ModelType.BOOLEAN).setRequired(false)).build();
    private static final AttributeDefinition NEW_PRIORITY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"new-priority", (ModelType)ModelType.INT).setValidator(PRIORITY_VALIDATOR)).build();

    protected abstract AttributeDefinition getMessageIDAttributeDefinition();

    protected abstract AttributeDefinition[] getReplyMessageParameterDefinitions();

    public void registerOperations(ManagementResourceRegistration registry, ResourceDescriptionResolver resolver) {
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_MESSAGES, resolver).setParameters(new AttributeDefinition[]{CommonAttributes.FILTER}).setReplyType(ModelType.LIST).setReplyParameters(this.getReplyMessageParameterDefinitions()).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_MESSAGES_AS_JSON, RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.FILTER}).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(COUNT_MESSAGES, RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.FILTER}).setReplyType(ModelType.LONG).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(REMOVE_MESSAGE, RESOLVER).setParameters(new AttributeDefinition[]{this.getMessageIDAttributeDefinition()}).setReplyType(ModelType.BOOLEAN).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(REMOVE_MESSAGES, RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.FILTER}).setReplyType(ModelType.INT).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(EXPIRE_MESSAGE, RESOLVER).setParameters(new AttributeDefinition[]{this.getMessageIDAttributeDefinition()}).setReplyType(ModelType.BOOLEAN).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(EXPIRE_MESSAGES, RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.FILTER}).setReplyType(ModelType.INT).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(SEND_MESSAGE_TO_DEAD_LETTER_ADDRESS, RESOLVER).setParameters(new AttributeDefinition[]{this.getMessageIDAttributeDefinition()}).setReplyType(ModelType.BOOLEAN).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(SEND_MESSAGES_TO_DEAD_LETTER_ADDRESS, RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.FILTER}).setReplyType(ModelType.INT).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(CHANGE_MESSAGE_PRIORITY, RESOLVER).setParameters(new AttributeDefinition[]{this.getMessageIDAttributeDefinition(), NEW_PRIORITY}).setReplyType(ModelType.BOOLEAN).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(CHANGE_MESSAGES_PRIORITY, RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.FILTER, NEW_PRIORITY}).setReplyType(ModelType.INT).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(MOVE_MESSAGE, RESOLVER).setParameters(new AttributeDefinition[]{this.getMessageIDAttributeDefinition(), OTHER_QUEUE_NAME, REJECT_DUPLICATES}).setReplyType(ModelType.INT).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(MOVE_MESSAGES, RESOLVER).setParameters(new AttributeDefinition[]{CommonAttributes.FILTER, OTHER_QUEUE_NAME, REJECT_DUPLICATES}).setReplyType(ModelType.INT).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_MESSAGE_COUNTER_AS_JSON, RESOLVER).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_MESSAGE_COUNTER_AS_HTML, RESOLVER).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(RESET_MESSAGE_COUNTER, RESOLVER).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_MESSAGE_COUNTER_HISTORY_AS_JSON, RESOLVER).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_MESSAGE_COUNTER_HISTORY_AS_HTML, RESOLVER).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(PAUSE, RESOLVER).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeOnlyOperation(RESUME, RESOLVER).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_CONSUMERS_AS_JSON, RESOLVER).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_DELIVERING_MESSAGES, resolver).setReplyType(ModelType.LIST).setReplyParameters(this.getReplyMapConsumerMessageParameterDefinition()).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_DELIVERING_MESSAGES_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_SCHEDULED_MESSAGES, resolver).setReplyType(ModelType.LIST).setReplyParameters(this.getReplyMessageParameterDefinitions()).build(), (OperationStepHandler)this);
        registry.registerOperationHandler((OperationDefinition)OperationDefinitionHelper.runtimeReadOnlyOperation(LIST_SCHEDULED_MESSAGES_AS_JSON, resolver).setReplyType(ModelType.STRING).build(), (OperationStepHandler)this);
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        OperationContext.RollbackHandler rh;
        if (ActiveMQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
            return;
        }
        final String operationName = operation.require("operation").asString();
        String queueName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName activeMQServiceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController activeMQService = context.getServiceRegistry(false).getService(activeMQServiceName);
        ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(activeMQService.getValue());
        final DelegatingQueueControl<T> control = this.getQueueControl(server, queueName);
        if (control == null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
        }
        boolean reversible = false;
        Object handback = null;
        try {
            ModelNode id;
            String json;
            String filter;
            if (LIST_MESSAGES.equals(operationName)) {
                filter = OperationDefinitionHelper.resolveFilter(context, operation);
                String json2 = control.listMessagesAsJSON(filter);
                context.getResult().set(ModelNode.fromJSONString((String)json2));
            } else if (LIST_MESSAGES_AS_JSON.equals(operationName)) {
                filter = OperationDefinitionHelper.resolveFilter(context, operation);
                context.getResult().set(control.listMessagesAsJSON(filter));
            } else if (LIST_DELIVERING_MESSAGES.equals(operationName)) {
                json = control.listDeliveringMessagesAsJSON();
                context.getResult().set(ModelNode.fromJSONString((String)json));
            } else if (LIST_DELIVERING_MESSAGES_AS_JSON.equals(operationName)) {
                context.getResult().set(control.listDeliveringMessagesAsJSON());
            } else if (LIST_SCHEDULED_MESSAGES.equals(operationName)) {
                json = control.listScheduledMessagesAsJSON();
                context.getResult().set(ModelNode.fromJSONString((String)json));
            } else if (LIST_SCHEDULED_MESSAGES_AS_JSON.equals(operationName)) {
                context.getResult().set(control.listScheduledMessagesAsJSON());
            } else if (COUNT_MESSAGES.equals(operationName)) {
                filter = OperationDefinitionHelper.resolveFilter(context, operation);
                context.getResult().set(control.countMessages(filter));
            } else if (REMOVE_MESSAGE.equals(operationName)) {
                id = this.getMessageIDAttributeDefinition().resolveModelAttribute(context, operation);
                context.getResult().set(control.removeMessage(id));
            } else if (REMOVE_MESSAGES.equals(operationName)) {
                filter = OperationDefinitionHelper.resolveFilter(context, operation);
                context.getResult().set(control.removeMessages(filter));
            } else if (EXPIRE_MESSAGES.equals(operationName)) {
                filter = OperationDefinitionHelper.resolveFilter(context, operation);
                context.getResult().set(control.expireMessages(filter));
            } else if (EXPIRE_MESSAGE.equals(operationName)) {
                id = this.getMessageIDAttributeDefinition().resolveModelAttribute(context, operation);
                context.getResult().set(control.expireMessage(id));
            } else if (SEND_MESSAGE_TO_DEAD_LETTER_ADDRESS.equals(operationName)) {
                id = this.getMessageIDAttributeDefinition().resolveModelAttribute(context, operation);
                context.getResult().set(control.sendMessageToDeadLetterAddress(id));
            } else if (SEND_MESSAGES_TO_DEAD_LETTER_ADDRESS.equals(operationName)) {
                filter = OperationDefinitionHelper.resolveFilter(context, operation);
                context.getResult().set(control.sendMessagesToDeadLetterAddress(filter));
            } else if (CHANGE_MESSAGE_PRIORITY.equals(operationName)) {
                id = this.getMessageIDAttributeDefinition().resolveModelAttribute(context, operation);
                int priority = NEW_PRIORITY.resolveModelAttribute(context, operation).asInt();
                context.getResult().set(control.changeMessagePriority(id, priority));
            } else if (CHANGE_MESSAGES_PRIORITY.equals(operationName)) {
                filter = OperationDefinitionHelper.resolveFilter(context, operation);
                int priority = NEW_PRIORITY.resolveModelAttribute(context, operation).asInt();
                context.getResult().set(control.changeMessagesPriority(filter, priority));
            } else if (MOVE_MESSAGE.equals(operationName)) {
                id = this.getMessageIDAttributeDefinition().resolveModelAttribute(context, operation);
                String otherQueue = OTHER_QUEUE_NAME.resolveModelAttribute(context, operation).asString();
                ModelNode rejectDuplicates = REJECT_DUPLICATES.resolveModelAttribute(context, operation);
                if (rejectDuplicates.isDefined()) {
                    context.getResult().set(control.moveMessage(id, otherQueue, rejectDuplicates.asBoolean()));
                } else {
                    context.getResult().set(control.moveMessage(id, otherQueue));
                }
            } else if (MOVE_MESSAGES.equals(operationName)) {
                filter = OperationDefinitionHelper.resolveFilter(context, operation);
                String otherQueue = OTHER_QUEUE_NAME.resolveModelAttribute(context, operation).asString();
                ModelNode rejectDuplicates = REJECT_DUPLICATES.resolveModelAttribute(context, operation);
                if (rejectDuplicates.isDefined()) {
                    context.getResult().set(control.moveMessages(filter, otherQueue, rejectDuplicates.asBoolean()));
                } else {
                    context.getResult().set(control.moveMessages(filter, otherQueue));
                }
            } else if (LIST_MESSAGE_COUNTER_AS_JSON.equals(operationName)) {
                context.getResult().set(control.listMessageCounter());
            } else if (LIST_MESSAGE_COUNTER_AS_HTML.equals(operationName)) {
                context.getResult().set(control.listMessageCounterAsHTML());
            } else if (LIST_MESSAGE_COUNTER_HISTORY_AS_JSON.equals(operationName)) {
                context.getResult().set(control.listMessageCounterHistory());
            } else if (LIST_MESSAGE_COUNTER_HISTORY_AS_HTML.equals(operationName)) {
                context.getResult().set(control.listMessageCounterHistoryAsHTML());
            } else if (RESET_MESSAGE_COUNTER.equals(operationName)) {
                control.resetMessageCounter();
                context.getResult();
            } else if (PAUSE.equals(operationName)) {
                control.pause();
                reversible = true;
                context.getResult();
            } else if (RESUME.equals(operationName)) {
                control.resume();
                reversible = true;
                context.getResult();
            } else if (LIST_CONSUMERS_AS_JSON.equals(operationName)) {
                context.getResult().set(control.listConsumersAsJSON());
            } else {
                handback = this.handleAdditionalOperation(operationName, operation, context, control.getDelegate());
                reversible = handback == null;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        if (reversible) {
            final Object rhHandback = handback;
            rh = new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    try {
                        if (AbstractQueueControlHandler.PAUSE.equals(operationName)) {
                            control.resume();
                        } else if (AbstractQueueControlHandler.RESUME.equals(operationName)) {
                            control.pause();
                        } else {
                            AbstractQueueControlHandler.this.revertAdditionalOperation(operationName, operation, context, control.getDelegate(), rhHandback);
                        }
                    }
                    catch (Exception e) {
                        MessagingLogger.ROOT_LOGGER.revertOperationFailed(e, this.getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.require("address")));
                    }
                }
            };
        } else {
            rh = OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER;
        }
        context.completeStep(rh);
    }

    protected AttributeDefinition[] getReplyMapConsumerMessageParameterDefinition() {
        return new AttributeDefinition[]{OperationDefinitionHelper.createNonEmptyStringAttribute("consumerName"), new ObjectListAttributeDefinition.Builder("elements", new ObjectTypeAttributeDefinition.Builder("element", this.getReplyMessageParameterDefinitions()).build()).build()};
    }

    protected abstract DelegatingQueueControl<T> getQueueControl(ActiveMQServer var1, String var2);

    protected abstract Object handleAdditionalOperation(String var1, ModelNode var2, OperationContext var3, T var4) throws OperationFailedException;

    protected abstract void revertAdditionalOperation(String var1, ModelNode var2, OperationContext var3, T var4, Object var5);

    protected final void throwUnimplementedOperationException(String operationName) {
        throw MessagingLogger.ROOT_LOGGER.unsupportedOperation(operationName);
    }

    public static interface DelegatingQueueControl<T> {
        public T getDelegate();

        public String listMessagesAsJSON(String var1) throws Exception;

        public long countMessages(String var1) throws Exception;

        public boolean removeMessage(ModelNode var1) throws Exception;

        public int removeMessages(String var1) throws Exception;

        public int expireMessages(String var1) throws Exception;

        public boolean expireMessage(ModelNode var1) throws Exception;

        public boolean sendMessageToDeadLetterAddress(ModelNode var1) throws Exception;

        public int sendMessagesToDeadLetterAddress(String var1) throws Exception;

        public boolean changeMessagePriority(ModelNode var1, int var2) throws Exception;

        public int changeMessagesPriority(String var1, int var2) throws Exception;

        public boolean moveMessage(ModelNode var1, String var2) throws Exception;

        public boolean moveMessage(ModelNode var1, String var2, boolean var3) throws Exception;

        public int moveMessages(String var1, String var2) throws Exception;

        public int moveMessages(String var1, String var2, boolean var3) throws Exception;

        public String listMessageCounter() throws Exception;

        public void resetMessageCounter() throws Exception;

        public String listMessageCounterAsHTML() throws Exception;

        public String listMessageCounterHistory() throws Exception;

        public String listMessageCounterHistoryAsHTML() throws Exception;

        public void pause() throws Exception;

        public void resume() throws Exception;

        public String listConsumersAsJSON() throws Exception;

        public String listScheduledMessagesAsJSON() throws Exception;

        public String listDeliveringMessagesAsJSON() throws Exception;
    }
}

