/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JGroupsBroadcastEndpoint;
import org.apache.activemq.artemis.api.core.jgroups.JChannelManager;
import org.apache.activemq.artemis.api.core.jgroups.JChannelWrapper;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

class JGroupsBroadcastEndpointFactory
implements BroadcastEndpointFactory {
    private final String channelName;
    private final ChannelFactory channelFactory;
    private Map<String, JChannel> channels;

    public JGroupsBroadcastEndpointFactory(String channelName, ChannelFactory channelFactory, Map<String, JChannel> channels) {
        this.channelName = channelName;
        this.channelFactory = channelFactory;
        this.channels = channels;
    }

    public JGroupsBroadcastEndpointFactory(String channelName, ChannelFactory channelFactory) {
        this(channelName, channelFactory, null);
    }

    public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
        JGroupsBroadcastEndpoint endpoint = new JGroupsBroadcastEndpoint(JChannelManager.getInstance(), this.channelName){

            public JChannel createChannel() throws Exception {
                JChannel channel = (JChannel)JGroupsBroadcastEndpointFactory.this.channelFactory.createChannel(JGroupsBroadcastEndpointFactory.this.channelName);
                if (JGroupsBroadcastEndpointFactory.this.channels != null) {
                    JGroupsBroadcastEndpointFactory.this.channels.put(JGroupsBroadcastEndpointFactory.this.channelName, channel);
                }
                return channel;
            }

            protected void internalCloseChannel(JChannelWrapper channel) {
                if (JGroupsBroadcastEndpointFactory.this.channels != null) {
                    JGroupsBroadcastEndpointFactory.this.channels.remove(JGroupsBroadcastEndpointFactory.this.channelName);
                }
                super.internalCloseChannel(channel);
            }
        };
        return endpoint.initChannel();
    }
}

