/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class CommonAttributes {
    static final PropertiesAttributeDefinition PROPERTIES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("properties", true).setAllowExpression(true)).setRestartAllServices()).build();

    CommonAttributes() {
    }

    static class AggregateAttributeMarshaller
    extends AttributeMarshaller {
        private final String elementName;

        AggregateAttributeMarshaller(String elementName) {
            this.elementName = elementName;
        }

        public void marshall(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            List serverFactoryReferences = resourceModel.get(attribute.getName()).asList();
            for (ModelNode currentReference : serverFactoryReferences) {
                writer.writeStartElement(this.elementName);
                writer.writeAttribute("name", currentReference.asString());
                writer.writeEndElement();
            }
        }
    }

    static class AggregateAttributeParser
    extends AttributeParser {
        private final String elementName;

        AggregateAttributeParser(String elementName) {
            this.elementName = elementName;
        }

        public boolean isParseAsElement() {
            return true;
        }

        public String getXmlName(AttributeDefinition attribute) {
            return this.elementName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            String xmlName;
            ModelNode listValue = operation.get(attribute.getName());
            if (!listValue.isDefined()) {
                listValue.setEmptyList();
            }
            if (!(xmlName = this.getXmlName(attribute)).equals(reader.getLocalName())) throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader, Collections.singleton(xmlName));
            int i = 0;
            if (i < reader.getAttributeCount()) {
                String attributeName = reader.getAttributeLocalName(i);
                if (!attributeName.equals("name")) throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                listValue.add(value);
            }
            if (reader.isEndElement()) return;
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }
}

