/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.accesscontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.BaseOperationAccessRequirement;
import org.jboss.as.cli.accesscontrol.CLIAccessControl;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.controller.client.ModelControllerClient;

public class HostServerOperationAccess
extends BaseOperationAccessRequirement {
    private int lastCheckedServer;
    private Map<String, List<String>> toCheck;
    private Map<String, List<String>> allowed;

    public HostServerOperationAccess(CommandContext ctx, String address, String operation) {
        this(address, operation);
        ctx.addEventListener(this);
    }

    HostServerOperationAccess(String address, String operation) {
        super(address, operation);
    }

    HostServerOperationAccess(String operation) {
        super(operation);
    }

    HostServerOperationAccess(OperationRequestAddress address, String operation) {
        super(address, operation);
    }

    @Override
    public void resetState() {
        this.lastCheckedServer = 0;
        this.toCheck = null;
        this.allowed = null;
    }

    public Collection<String> getAllowedHosts(CommandContext ctx) {
        if (this.allowed == null) {
            this.initAllowedLists(ctx);
        }
        return this.allowed.keySet();
    }

    public Collection<String> getAllowedServers(CommandContext ctx, String host) {
        List<String> servers;
        if (this.allowed == null) {
            this.initAllowedLists(ctx);
        }
        return (servers = this.allowed.get(host)) == null ? Collections.emptyList() : servers;
    }

    protected void initAllowedLists(CommandContext ctx) {
        if (ctx.getConfig().isAccessControl()) {
            if (!this.isSatisfied(ctx)) {
                this.allowed = Collections.emptyMap();
            } else {
                this.completeAccessCheck(ctx);
            }
        } else {
            ModelControllerClient client = ctx.getModelControllerClient();
            this.allowed = new HashMap<String, List<String>>();
            DefaultOperationRequestAddress hostAddress = new DefaultOperationRequestAddress();
            hostAddress.toNodeType("host");
            List<String> hosts = Util.getNodeNames(client, null, "host");
            for (String host : hosts) {
                hostAddress.toNode(host);
                List<String> servers = Util.getNodeNames(client, hostAddress, "server");
                if (servers.isEmpty()) continue;
                this.allowed.put(host, servers);
            }
        }
    }

    protected void completeAccessCheck(CommandContext ctx) {
        ModelControllerClient client = ctx.getModelControllerClient();
        this.allowed = new HashMap<String, List<String>>();
        DefaultOperationRequestAddress hostAddress = new DefaultOperationRequestAddress();
        hostAddress.toNodeType("host");
        String[] parent = new String[4];
        parent[0] = "host";
        parent[2] = "server";
        for (Map.Entry<String, List<String>> entry : this.toCheck.entrySet()) {
            String host = entry.getKey();
            hostAddress.toNode(host);
            List<String> servers = entry.getValue();
            ArrayList<String> allowedServers = null;
            int i = 0;
            if (servers == null) {
                servers = Util.getNodeNames(client, hostAddress, "server");
            } else {
                allowedServers = new ArrayList<String>();
                this.allowed.put(host, allowedServers);
                allowedServers.add(servers.get(this.lastCheckedServer));
                i = this.lastCheckedServer + 1;
            }
            parent[1] = host;
            while (i < servers.size()) {
                String server;
                parent[3] = server = servers.get(i++);
                if (!CLIAccessControl.isExecute(client, parent, this.address, this.operation)) continue;
                if (allowedServers == null) {
                    allowedServers = new ArrayList();
                    this.allowed.put(host, allowedServers);
                }
                allowedServers.add(server);
            }
        }
    }

    @Override
    protected boolean checkAccess(CommandContext ctx) {
        ModelControllerClient client = ctx.getModelControllerClient();
        List<String> hosts = Util.getNodeNames(client, null, "host");
        if (hosts.isEmpty()) {
            return false;
        }
        DefaultOperationRequestAddress hostAddress = new DefaultOperationRequestAddress();
        hostAddress.toNodeType("host");
        String[] parent = new String[4];
        parent[0] = "host";
        parent[2] = "server";
        this.toCheck = new HashMap<String, List<String>>();
        boolean satisfied = false;
        block0: for (String host : hosts) {
            if (!satisfied) {
                this.lastCheckedServer = 0;
                hostAddress.toNode(host);
                parent[1] = host;
                List<String> servers = Util.getNodeNames(client, hostAddress, "server");
                Iterator<String> iterator = servers.iterator();
                while (iterator.hasNext()) {
                    String server;
                    parent[3] = server = iterator.next();
                    if (CLIAccessControl.isExecute(client, parent, this.address, this.operation)) {
                        this.toCheck.put(host, servers);
                        satisfied = true;
                        continue block0;
                    }
                    ++this.lastCheckedServer;
                }
                continue;
            }
            this.toCheck.put(host, null);
        }
        return satisfied;
    }
}

