/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValue;

public class SimpleMarshalledValueExternalizer<T>
implements Externalizer<SimpleMarshalledValue<T>> {
    public SimpleMarshalledValue<T> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = input.readInt();
        byte[] bytes = null;
        if (size > 0) {
            bytes = new byte[size];
            input.readFully(bytes);
        }
        return new SimpleMarshalledValue(bytes);
    }

    public void writeObject(ObjectOutput output, SimpleMarshalledValue<T> object) throws IOException {
        byte[] bytes = object.getBytes();
        if (bytes != null) {
            output.writeInt(bytes.length);
            output.write(bytes);
        } else {
            output.writeInt(0);
        }
    }

    public Class<SimpleMarshalledValue<T>> getTargetClass() {
        return SimpleMarshalledValue.class;
    }
}

