/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectMapAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

class ValidateModelStepHandler
implements OperationStepHandler {
    private static volatile ValidateModelStepHandler INSTANCE;
    private final OperationStepHandler extraValidationStepHandler;

    private ValidateModelStepHandler(OperationStepHandler extraValidationStepHandler) {
        this.extraValidationStepHandler = extraValidationStepHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ValidateModelStepHandler getInstance(OperationStepHandler extraValidationStepHandler) {
        if (INSTANCE != null) return INSTANCE;
        Class<ValidateModelStepHandler> clazz = ValidateModelStepHandler.class;
        synchronized (ValidateModelStepHandler.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ValidateModelStepHandler(extraValidationStepHandler);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = this.loadResource(context);
        if (resource == null) {
            return;
        }
        if (this.extraValidationStepHandler != null) {
            context.addStep(operation, this.extraValidationStepHandler, OperationContext.Stage.MODEL);
        }
        ModelNode model = resource.getModel();
        ImmutableManagementResourceRegistration resourceRegistration = context.getResourceRegistration();
        Set<String> attributeNames = resourceRegistration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        for (final String attributeName : attributeNames) {
            boolean has = model.hasDefined(attributeName);
            AttributeAccess access = resourceRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            if (access.getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
            final AttributeDefinition attr = access.getAttributeDefinition();
            if (!has && this.isRequired(attr, model)) {
                this.attemptReadMissingAttributeValueFromHandler(context, access, attributeName, new ErrorHandler(){

                    @Override
                    public void throwError() throws OperationFailedException {
                        throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.required(attributeName));
                    }
                });
            }
            if (!has) continue;
            String[] requires = attr.getRequires();
            if (requires != null) {
                for (final String required : requires) {
                    if (model.hasDefined(required)) continue;
                    AttributeDefinition requiredAttr = ValidateModelStepHandler.getAttributeDefinition(required, resourceRegistration);
                    if (requiredAttr == null) {
                        ControllerLogger.MGMT_OP_LOGGER.debugf("AttributeDefinition for %s required by %s is null", required, attributeName);
                        continue;
                    }
                    if (this.hasAlternative(this.getRelevantAlteratives(requiredAttr.getAlternatives(), requires), model)) continue;
                    this.attemptReadMissingAttributeValueFromHandler(context, access, attributeName, new ErrorHandler(){

                        @Override
                        public void throwError() throws OperationFailedException {
                            throw ControllerLogger.ROOT_LOGGER.requiredAttributeNotSet(required, attr.getName());
                        }
                    });
                }
            }
            if (!this.isAllowed(attr, model)) {
                String[] alts = attr.getAlternatives();
                StringBuilder sb = null;
                if (alts != null) {
                    for (String alt : alts) {
                        if (!model.hasDefined(alt)) continue;
                        if (sb == null) {
                            sb = new StringBuilder();
                        } else {
                            sb.append(", ");
                        }
                        sb.append(alt);
                    }
                }
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidAttributeCombo(attributeName, sb));
            }
            this.handleObjectAttributes(model, attr, attributeName);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private static AttributeDefinition getAttributeDefinition(String name, ImmutableManagementResourceRegistration resourceRegistration) {
        AttributeAccess aa = resourceRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, name);
        return aa == null ? null : aa.getAttributeDefinition();
    }

    private static AttributeDefinition getAttributeDefinition(String name, AttributeDefinition[] attrs) {
        for (AttributeDefinition peer : attrs) {
            if (!name.equals(peer.getName())) continue;
            return peer;
        }
        return null;
    }

    private void attemptReadMissingAttributeValueFromHandler(OperationContext context, AttributeAccess attributeAccess, String attributeName, final ErrorHandler errorHandler) throws OperationFailedException {
        OperationStepHandler handler = attributeAccess.getReadHandler();
        if (handler == null) {
            errorHandler.throwError();
        } else {
            ModelNode readAttr = Util.getReadAttributeOperation(context.getCurrentAddress(), attributeName);
            final ModelNode resultHolder = new ModelNode();
            context.addStep(resultHolder, readAttr, handler, OperationContext.Stage.MODEL, true);
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (!resultHolder.isDefined() && !resultHolder.hasDefined("result")) {
                        errorHandler.throwError();
                    }
                }
            }, OperationContext.Stage.MODEL);
        }
    }

    private void handleObjectAttributes(ModelNode model, AttributeDefinition attr, String absoluteParentName) throws OperationFailedException {
        block3: {
            block4: {
                block2: {
                    if (!(attr instanceof ObjectTypeAttributeDefinition)) break block2;
                    this.validateNestedAttributes(model.get(attr.getName()), (ObjectTypeAttributeDefinition)attr, absoluteParentName);
                    break block3;
                }
                if (!(attr instanceof ObjectListAttributeDefinition)) break block4;
                ObjectTypeAttributeDefinition valueType = ((ObjectListAttributeDefinition)attr).getValueType();
                ModelNode list = model.get(attr.getName());
                for (int i = 0; i < list.asInt(); ++i) {
                    this.validateNestedAttributes(list.get(i), valueType, absoluteParentName + "[" + i + "]");
                }
                break block3;
            }
            if (!(attr instanceof ObjectMapAttributeDefinition)) break block3;
            ObjectTypeAttributeDefinition valueType = ((ObjectMapAttributeDefinition)attr).getValueType();
            ModelNode map = model.get(attr.getName());
            for (String key : map.keys()) {
                this.validateNestedAttributes(map.get(key), valueType, absoluteParentName + "." + key);
            }
        }
    }

    private void validateNestedAttributes(ModelNode subModel, ObjectTypeAttributeDefinition attr, String absoluteParentName) throws OperationFailedException {
        AttributeDefinition[] subAttrs;
        if (!subModel.isDefined()) {
            return;
        }
        for (AttributeDefinition subAttr : subAttrs = attr.getValueTypes()) {
            String subAttributeName = subAttr.getName();
            String absoluteName = absoluteParentName + "." + subAttributeName;
            if (!subModel.hasDefined(subAttributeName) && this.isRequired(subAttr, subModel)) {
                throw new OperationFailedException(ControllerLogger.MGMT_OP_LOGGER.required(subAttributeName));
            }
            if (!subModel.hasDefined(subAttributeName)) continue;
            String[] requires = subAttr.getRequires();
            if (requires != null) {
                for (String required : requires) {
                    if (subModel.hasDefined(required)) continue;
                    AttributeDefinition requiredAttr = ValidateModelStepHandler.getAttributeDefinition(required, subAttrs);
                    if (requiredAttr == null) {
                        ControllerLogger.MGMT_OP_LOGGER.debugf("AttributeDefinition for %s required by %s of %s is null", required, subAttributeName, absoluteParentName);
                        continue;
                    }
                    if (this.hasAlternative(this.getRelevantAlteratives(requiredAttr.getAlternatives(), requires), subModel)) continue;
                    throw ControllerLogger.MGMT_OP_LOGGER.requiredAttributeNotSet(absoluteParentName + "." + required, absoluteName);
                }
            }
            if (!this.isAllowed(subAttr, subModel)) {
                String[] alts = subAttr.getAlternatives();
                StringBuilder sb = null;
                if (alts != null) {
                    for (String alt : alts) {
                        if (!subModel.hasDefined(alt)) continue;
                        if (sb == null) {
                            sb = new StringBuilder();
                        } else {
                            sb.append(", ");
                        }
                        sb.append(absoluteParentName + "." + alt);
                    }
                }
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.invalidAttributeCombo(absoluteName, sb));
            }
            this.handleObjectAttributes(subModel, subAttr, absoluteName);
        }
    }

    private boolean isRequired(AttributeDefinition def, ModelNode model) {
        return def.isRequired() && !def.isResourceOnly() && !this.hasAlternative(def.getAlternatives(), model);
    }

    private boolean isAllowed(AttributeDefinition def, ModelNode model) {
        String[] alternatives = def.getAlternatives();
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!model.hasDefined(alternative)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasAlternative(String[] alternatives, ModelNode operationObject) {
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getRelevantAlteratives(String[] alternatives, String[] relevant) {
        if (alternatives == null || relevant == null || relevant.length == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(alternatives.length);
        block0: for (String alt : alternatives) {
            for (String rel : relevant) {
                if (!alt.equals(rel)) continue;
                result.add(alt);
                continue block0;
            }
        }
        return result.size() == 0 ? null : result.toArray(new String[result.size()]);
    }

    private Resource loadResource(OperationContext context) {
        PathAddress address = context.getCurrentAddress();
        PathAddress current = PathAddress.EMPTY_ADDRESS;
        ImmutableManagementResourceRegistration mrr = context.getRootResourceRegistration();
        Resource resource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        for (PathElement element : address) {
            if (resource.isRuntime()) {
                return null;
            }
            ImmutableManagementResourceRegistration subMrr = mrr.getSubModel(current = current.append(element));
            if (subMrr == null || subMrr.isRuntimeOnly() || subMrr.isRemote()) {
                return null;
            }
            if (!resource.hasChild(element)) {
                return null;
            }
            resource = context.readResourceFromRoot(current, false);
        }
        if (resource.isRuntime()) {
            return null;
        }
        return resource;
    }

    private static interface ErrorHandler {
        public void throwError() throws OperationFailedException;
    }
}

