/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import javax.ejb.Asynchronous;
import javax.net.ssl.SSLContext;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.EJBReceiverSessionCreationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.httpclient.ejb.EjbHeaders;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpEJBInvocationBuilder;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectResolver;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.httpclient.ejb.PackedInteger;
import org.wildfly.httpclient.transaction.XidProvider;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.RemoteTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.XAOutflowHandle;
import org.xnio.IoUtils;

class HttpEJBReceiver
extends EJBReceiver {
    private final io.undertow.util.AttachmentKey<EjbContextData> EJB_CONTEXT_DATA = io.undertow.util.AttachmentKey.create(EjbContextData.class);
    private final AttachmentKey<String> INVOCATION_ID = new AttachmentKey();
    private final RemoteTransactionContext transactionContext = RemoteTransactionContext.getInstance();
    private static final AtomicLong invocationIdGenerator = new AtomicLong();
    private static final AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    HttpEJBReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInvocation(EJBReceiverInvocationContext receiverContext) throws Exception {
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator locator = clientInvocationContext.getLocator();
        URI uri = clientInvocationContext.getDestination();
        WildflyHttpContext current = WildflyHttpContext.getCurrent();
        HttpTargetContext targetContext = current.getTargetContext(uri);
        if (targetContext == null) {
            throw EjbHttpClientMessages.MESSAGES.couldNotResolveTargetForLocator(locator);
        }
        if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
            HttpEJBReceiver httpEJBReceiver = this;
            synchronized (httpEJBReceiver) {
                if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
                    targetContext.putAttachment(this.EJB_CONTEXT_DATA, (Object)new EjbContextData());
                }
            }
        }
        targetContext.awaitSessionId(false);
        EjbContextData ejbData = (EjbContextData)targetContext.getAttachment(this.EJB_CONTEXT_DATA);
        HttpEJBInvocationBuilder builder = new HttpEJBInvocationBuilder().setInvocationType(HttpEJBInvocationBuilder.InvocationType.METHOD_INVOCATION).setMethod(clientInvocationContext.getInvokedMethod()).setAppName(locator.getAppName()).setModuleName(locator.getModuleName()).setDistinctName(locator.getDistinctName()).setView(clientInvocationContext.getViewClass().getName()).setBeanName(locator.getBeanName());
        if (locator instanceof StatefulEJBLocator) {
            builder.setBeanId(Base64.getUrlEncoder().encodeToString(locator.asStateful().getSessionId().getEncodedForm()));
        }
        if (clientInvocationContext.getInvokedMethod().getReturnType() == Future.class) {
            receiverContext.proceedAsynchronously();
            if (targetContext.getSessionId() != null) {
                long invocationId = invocationIdGenerator.incrementAndGet();
                String invocationIdString = Long.toString(invocationId);
                builder.setInvocationId(invocationIdString);
                clientInvocationContext.putAttachment(this.INVOCATION_ID, (Object)invocationIdString);
            }
        } else if (clientInvocationContext.getInvokedMethod().getReturnType() == Void.TYPE) {
            if (clientInvocationContext.getInvokedMethod().isAnnotationPresent(Asynchronous.class)) {
                receiverContext.proceedAsynchronously();
            } else if (ejbData.asyncMethods.contains(clientInvocationContext.getInvokedMethod())) {
                receiverContext.proceedAsynchronously();
            }
        }
        boolean compressResponse = receiverContext.getClientInvocationContext().isCompressResponse();
        ClientRequest request = builder.createRequest(targetContext.getUri().getPath());
        if (compressResponse) {
            request.getRequestHeaders().put(Headers.ACCEPT_ENCODING, Headers.GZIP.toString());
        }
        request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
        boolean compressRequest = receiverContext.getClientInvocationContext().isCompressRequest();
        if (compressRequest) {
            request.getRequestHeaders().put(Headers.CONTENT_ENCODING, Headers.GZIP.toString());
        }
        SSLContext sslContext = receiverContext.getSSLContext();
        AuthenticationConfiguration authenticationConfiguration = receiverContext.getAuthenticationConfiguration();
        if (sslContext == null || authenticationConfiguration == null) {
            AuthenticationContext context = AuthenticationContext.captureCurrent();
            if (sslContext == null) {
                sslContext = CLIENT.getSSLContext(uri, context);
            }
            if (authenticationConfiguration == null) {
                authenticationConfiguration = CLIENT.getAuthenticationConfiguration(uri, context);
            }
        }
        targetContext.sendRequest(request, sslContext, authenticationConfiguration, output -> {
            OutputStream data = output;
            if (compressRequest) {
                data = new GZIPOutputStream(data);
            }
            try {
                this.marshalEJBRequest(Marshalling.createByteOutput((OutputStream)data), clientInvocationContext, targetContext);
            }
            finally {
                IoUtils.safeClose((Closeable)data);
            }
        }, (input, response) -> {
            if (response.getResponseCode() == 202 && clientInvocationContext.getInvokedMethod().getReturnType() == Void.TYPE) {
                ejbContextData.asyncMethods.add(clientInvocationContext.getInvokedMethod());
            }
            Exception exception = null;
            Object returned = null;
            try {
                MarshallingConfiguration marshallingConfiguration = this.createMarshallingConfig(targetContext.getUri());
                Unmarshaller unmarshaller = targetContext.createUnmarshaller(marshallingConfiguration);
                unmarshaller.start((ByteInput)new InputStreamByteInput(input));
                returned = unmarshaller.readObject();
                Map<String, Object> attachments = HttpEJBReceiver.readAttachments((ObjectInput)unmarshaller);
                if (unmarshaller.read() != -1) {
                    exception = EjbHttpClientMessages.MESSAGES.unexpectedDataInResponse();
                }
                unmarshaller.finish();
                if (response.getResponseCode() >= 400) {
                    receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new StaticResultProducer((Exception)returned, null));
                    return;
                }
            }
            catch (Exception e) {
                exception = e;
            }
            Object ret = returned;
            Exception ex = exception;
            receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new StaticResultProducer(ex, ret));
        }, e -> receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new StaticResultProducer(e instanceof Exception ? (Exception)e : new RuntimeException(e), null)), EjbHeaders.EJB_RESPONSE_VERSION_ONE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatefulEJBLocator<?> createSession(EJBReceiverSessionCreationContext receiverContext) throws Exception {
        WildflyHttpContext current;
        HttpTargetContext targetContext;
        EJBLocator locator = receiverContext.getClientInvocationContext().getLocator();
        URI uri = receiverContext.getClientInvocationContext().getDestination();
        SSLContext sslContext = receiverContext.getSSLContext();
        AuthenticationConfiguration authenticationConfiguration = receiverContext.getAuthenticationConfiguration();
        if (sslContext == null || authenticationConfiguration == null) {
            AuthenticationContext context = AuthenticationContext.captureCurrent();
            if (sslContext == null) {
                sslContext = CLIENT.getSSLContext(uri, context);
            }
            if (authenticationConfiguration == null) {
                authenticationConfiguration = CLIENT.getAuthenticationConfiguration(uri, context);
            }
        }
        if ((targetContext = (current = WildflyHttpContext.getCurrent()).getTargetContext(uri)) == null) {
            throw EjbHttpClientMessages.MESSAGES.couldNotResolveTargetForLocator(locator);
        }
        if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
            HttpEJBReceiver httpEJBReceiver = this;
            synchronized (httpEJBReceiver) {
                if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
                    targetContext.putAttachment(this.EJB_CONTEXT_DATA, (Object)new EjbContextData());
                }
            }
        }
        targetContext.awaitSessionId(true);
        CompletableFuture result = new CompletableFuture();
        HttpEJBInvocationBuilder builder = new HttpEJBInvocationBuilder().setInvocationType(HttpEJBInvocationBuilder.InvocationType.STATEFUL_CREATE).setAppName(locator.getAppName()).setModuleName(locator.getModuleName()).setDistinctName(locator.getDistinctName()).setView(locator.getViewType().getName()).setBeanName(locator.getBeanName());
        ClientRequest request = builder.createRequest(targetContext.getUri().getPath());
        targetContext.sendRequest(request, sslContext, authenticationConfiguration, output -> {
            MarshallingConfiguration config = this.createMarshallingConfig(targetContext.getUri());
            Marshaller marshaller = targetContext.createMarshaller(config);
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            this.writeTransaction((Transaction)ContextTransactionManager.getInstance().getTransaction(), (DataOutput)marshaller, targetContext.getUri());
            marshaller.finish();
        }, (unmarshaller, response) -> {
            String sessionId = response.getResponseHeaders().getFirst(EjbHeaders.EJB_SESSION_ID);
            if (sessionId == null) {
                result.completeExceptionally(EjbHttpClientMessages.MESSAGES.noSessionIdInResponse());
            } else {
                SessionID sessionID = SessionID.createSessionID((byte[])Base64.getUrlDecoder().decode(sessionId));
                result.complete(locator.withSession(sessionID));
            }
        }, result::completeExceptionally, EjbHeaders.EJB_RESPONSE_NEW_SESSION, null);
        return (StatefulEJBLocator)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        EJBClientInvocationContext clientInvocationContext = receiverContext.getClientInvocationContext();
        EJBLocator locator = clientInvocationContext.getLocator();
        Affinity affinity = locator.getAffinity();
        URI uri = clientInvocationContext.getDestination();
        WildflyHttpContext current = WildflyHttpContext.getCurrent();
        HttpTargetContext targetContext = current.getTargetContext(uri);
        if (targetContext == null) {
            throw EjbHttpClientMessages.MESSAGES.couldNotResolveTargetForLocator(locator);
        }
        if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
            HttpEJBReceiver httpEJBReceiver = this;
            synchronized (httpEJBReceiver) {
                if (targetContext.getAttachment(this.EJB_CONTEXT_DATA) == null) {
                    targetContext.putAttachment(this.EJB_CONTEXT_DATA, (Object)new EjbContextData());
                }
            }
        }
        targetContext.awaitSessionId(false);
        HttpEJBInvocationBuilder builder = new HttpEJBInvocationBuilder().setInvocationType(HttpEJBInvocationBuilder.InvocationType.CANCEL).setAppName(locator.getAppName()).setModuleName(locator.getModuleName()).setDistinctName(locator.getDistinctName()).setCancelIfRunning(cancelIfRunning).setInvocationId((String)receiverContext.getClientInvocationContext().getAttachment(this.INVOCATION_ID)).setBeanName(locator.getBeanName());
        CompletableFuture result = new CompletableFuture();
        targetContext.sendRequest(builder.createRequest(targetContext.getUri().getPath()), receiverContext.getSSLContext(), receiverContext.getAuthenticationConfiguration(), null, (stream, response) -> {
            result.complete(true);
            IoUtils.safeClose((Closeable)stream);
        }, throwable -> result.complete(false), null, null);
        try {
            return (Boolean)result.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
    }

    private MarshallingConfiguration createMarshallingConfig(URI uri) {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setObjectResolver((ObjectResolver)new HttpProtocolV1ObjectResolver(uri));
        marshallingConfiguration.setObjectTable((ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
        marshallingConfiguration.setVersion(2);
        return marshallingConfiguration;
    }

    private void marshalEJBRequest(ByteOutput byteOutput, EJBClientInvocationContext clientInvocationContext, HttpTargetContext targetContext) throws IOException, RollbackException, SystemException {
        MarshallingConfiguration config = this.createMarshallingConfig(targetContext.getUri());
        Marshaller marshaller = targetContext.createMarshaller(config);
        marshaller.start(byteOutput);
        this.writeTransaction(clientInvocationContext.getTransaction(), (DataOutput)marshaller, targetContext.getUri());
        Object[] methodParams = clientInvocationContext.getParameters();
        if (methodParams != null && methodParams.length > 0) {
            for (Object methodParam : methodParams) {
                marshaller.writeObject(methodParam);
            }
        }
        Map privateAttachments = clientInvocationContext.getAttachments();
        Map contextData = clientInvocationContext.getContextData();
        int privateAttachmentsSize = privateAttachments.size() - (privateAttachments.containsKey(this.INVOCATION_ID) ? 1 : 0);
        if (contextData == null && privateAttachmentsSize == 0) {
            marshaller.writeByte(0);
        } else {
            int totalAttachments = contextData.size();
            if (privateAttachmentsSize > 0) {
                ++totalAttachments;
            }
            PackedInteger.writePackedInteger((DataOutput)marshaller, totalAttachments);
            for (Map.Entry invocationContextData : contextData.entrySet()) {
                marshaller.writeObject(invocationContextData.getKey());
                marshaller.writeObject(invocationContextData.getValue());
            }
            if (privateAttachmentsSize > 0) {
                marshaller.writeObject((Object)"org.jboss.ejb.client.invocation.attachments");
                HashMap copy = new HashMap(privateAttachments);
                copy.remove(this.INVOCATION_ID);
                marshaller.writeObject(copy);
            }
        }
        marshaller.finish();
    }

    private XAOutflowHandle writeTransaction(Transaction transaction, DataOutput dataOutput, URI uri) throws IOException, RollbackException, SystemException {
        if (transaction == null) {
            dataOutput.writeByte(0);
            return null;
        }
        if (transaction instanceof RemoteTransaction) {
            XidProvider ir = (XidProvider)((RemoteTransaction)transaction).getProviderInterface(XidProvider.class);
            if (ir == null) {
                throw EjbHttpClientMessages.MESSAGES.cannotEnlistTx();
            }
            Xid xid = ir.getXid();
            dataOutput.writeByte(1);
            dataOutput.writeInt(xid.getFormatId());
            byte[] gtid = xid.getGlobalTransactionId();
            dataOutput.writeInt(gtid.length);
            dataOutput.write(gtid);
            byte[] bq = xid.getBranchQualifier();
            dataOutput.writeInt(bq.length);
            dataOutput.write(bq);
            return null;
        }
        if (transaction instanceof LocalTransaction) {
            LocalTransaction localTransaction = (LocalTransaction)transaction;
            XAOutflowHandle outflowHandle = this.transactionContext.outflowTransaction(uri, localTransaction);
            Xid xid = outflowHandle.getXid();
            dataOutput.writeByte(2);
            dataOutput.writeInt(xid.getFormatId());
            byte[] gtid = xid.getGlobalTransactionId();
            dataOutput.writeInt(gtid.length);
            dataOutput.write(gtid);
            byte[] bq = xid.getBranchQualifier();
            dataOutput.writeInt(bq.length);
            dataOutput.write(bq);
            dataOutput.writeInt(outflowHandle.getRemainingTime());
            return outflowHandle;
        }
        throw EjbHttpClientMessages.MESSAGES.cannotEnlistTx();
    }

    private static Map<String, Object> readAttachments(ObjectInput input) throws IOException, ClassNotFoundException {
        int numAttachments = PackedInteger.readPackedInteger(input);
        if (numAttachments == 0) {
            return null;
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>(numAttachments);
        for (int i = 0; i < numAttachments; ++i) {
            String key = (String)input.readObject();
            Object val = input.readObject();
            attachments.put(key, val);
        }
        return attachments;
    }

    private static class EjbContextData {
        final Set<Method> asyncMethods = Collections.newSetFromMap(new ConcurrentHashMap());

        private EjbContextData() {
        }
    }

    private static class StaticResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final Exception ex;
        private final Object ret;

        public StaticResultProducer(Exception ex, Object ret) {
            this.ex = ex;
            this.ret = ret;
        }

        public Object getResult() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
            return this.ret;
        }

        public void discardResult() {
        }
    }
}

