/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tracer;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.jboss.jca.core.tracer.SecurityActions;
import org.jboss.jca.core.tracer.TraceEvent;
import org.jboss.logging.Logger;

public class Tracer {
    private static Logger log = Logger.getLogger(Tracer.class);
    private static boolean enabled = log.isTraceEnabled();
    private static boolean recordCallstacks = false;
    private static boolean confidential = false;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean v) {
        enabled = v;
    }

    public static boolean isRecordCallstacks() {
        return recordCallstacks && !confidential;
    }

    public static boolean isConfidential() {
        return confidential;
    }

    public static synchronized void getConnectionListener(String poolName, Object mcp, Object cl, boolean pooled, boolean interleaving, Throwable callstack) {
        if (!interleaving) {
            if (pooled) {
                log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 0, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
            } else {
                log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 1, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
            }
        } else if (pooled) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 2, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 3, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        }
    }

    public static synchronized void returnConnectionListener(String poolName, Object mcp, Object cl, boolean kill, boolean interleaving, Throwable callstack) {
        if (!interleaving) {
            if (!kill) {
                log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 10, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
            } else {
                log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 11, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
            }
        } else if (!kill) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 12, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 13, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        }
    }

    public static synchronized void clearConnectionListener(String poolName, Object mcp, Object cl) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 14, Integer.toHexString(System.identityHashCode(cl))));
    }

    public static synchronized void enlistConnectionListener(String poolName, Object mcp, Object cl, String tx, boolean success, boolean interleaving) {
        if (!interleaving) {
            if (success) {
                log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 20, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
            } else {
                log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 21, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
            }
        } else if (success) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 22, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
        } else {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 23, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
        }
    }

    public static synchronized void delistConnectionListener(String poolName, Object mcp, Object cl, String tx, boolean success, boolean rollbacked, boolean interleaving) {
        if (!rollbacked) {
            if (!interleaving) {
                if (success) {
                    log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 30, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
                } else {
                    log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 31, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
                }
            } else if (success) {
                log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 32, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
            } else {
                log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 33, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
            }
        } else if (success) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 34, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
        } else {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 35, Integer.toHexString(System.identityHashCode(cl)), tx.replace('-', '_')));
        }
    }

    public static synchronized void getConnection(String poolName, Object mcp, Object cl, Object connection) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 40, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection))));
    }

    public static synchronized void returnConnection(String poolName, Object mcp, Object cl, Object connection) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 41, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection))));
    }

    public static synchronized void clearConnection(String poolName, Object mcp, Object cl, Object connection) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 42, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection))));
    }

    public static synchronized void exception(String poolName, Object mcp, Object cl, Throwable exception) {
        if (!confidential) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 50, Integer.toHexString(System.identityHashCode(cl)), Tracer.toString(exception)));
        }
    }

    public static synchronized void createConnectionListener(String poolName, Object mcp, Object cl, Object mc, boolean get, boolean prefill, boolean incrementer, Throwable callstack) {
        if (get) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 60, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(mc)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else if (prefill) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 61, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(mc)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else if (incrementer) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 62, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(mc)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        }
    }

    public static synchronized void destroyConnectionListener(String poolName, Object mcp, Object cl, boolean ret, boolean idle, boolean invalid, boolean flush, boolean error, boolean prefill, boolean incrementer, Throwable callstack) {
        if (ret) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 70, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else if (idle) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 71, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else if (invalid) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 72, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else if (flush) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 73, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else if (error) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 74, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else if (prefill) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 75, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        } else if (incrementer) {
            log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 76, Integer.toHexString(System.identityHashCode(cl)), !confidential && callstack != null ? Tracer.toString(callstack) : ""));
        }
    }

    public static synchronized void createManagedConnectionPool(String poolName, Object mcp) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 80, "NONE"));
    }

    public static synchronized void destroyManagedConnectionPool(String poolName, Object mcp) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 81, "NONE"));
    }

    public static synchronized void pushCCMContext(String key, Throwable callstack) {
        log.tracef("%s", (Object)new TraceEvent("CachedConnectionManager", "NONE", 90, "NONE", key, callstack != null ? Tracer.toString(callstack) : ""));
    }

    public static synchronized void popCCMContext(String key, Throwable callstack) {
        log.tracef("%s", (Object)new TraceEvent("CachedConnectionManager", "NONE", 91, "NONE", key, callstack != null ? Tracer.toString(callstack) : ""));
    }

    public static synchronized void registerCCMConnection(String poolName, Object mcp, Object cl, Object connection, String key) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 92, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection)), key));
    }

    public static synchronized void unregisterCCMConnection(String poolName, Object mcp, Object cl, Object connection, String key) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 93, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection)), key));
    }

    public static synchronized void unknownCCMConnection(String poolName, Object mcp, Object cl, Object connection, String key) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 95, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection)), key));
    }

    public static synchronized void closeCCMConnection(String poolName, Object mcp, Object cl, Object connection, String key) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 96, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection)), key));
    }

    public static synchronized void ccmUserTransaction(String poolName, Object mcp, Object cl, Object connection, String key) {
        log.tracef("%s", (Object)new TraceEvent(poolName, Integer.toHexString(System.identityHashCode(mcp)), 94, Integer.toHexString(System.identityHashCode(cl)), Integer.toHexString(System.identityHashCode(connection)), key));
    }

    private static synchronized String toString(Throwable exception) {
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter((Writer)caw, true);
        exception.printStackTrace(pw);
        pw.flush();
        char[] data = caw.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            sb = c == '\n' ? sb.append('|') : (c == '\r' ? sb.append('/') : (c == '\t' ? sb.append('\\') : (c == ' ' ? sb.append('_') : sb.append(c))));
        }
        return sb.toString();
    }

    static {
        log.tracef("%s", (Object)new TraceEvent("1.4.5.Final", "NONE", 100, "NONE"));
        String value = SecurityActions.getSystemProperty("ironjacamar.tracer.callstacks");
        if (value != null && !value.trim().equals("")) {
            try {
                recordCallstacks = Boolean.valueOf(value);
            }
            catch (Throwable t) {
                recordCallstacks = true;
            }
        }
        if ((value = SecurityActions.getSystemProperty("ironjacamar.tracer.confidential")) != null && !value.trim().equals("")) {
            try {
                confidential = Boolean.valueOf(value);
            }
            catch (Throwable t) {
                confidential = true;
            }
        }
    }
}

