/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.net.URI;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.remoting3.Connection;

final class ProtocolV3ObjectResolver
implements ObjectResolver {
    private final NodeAffinity peerNodeAffinity;
    private final NodeAffinity selfNodeAffinity;
    private final URIAffinity peerUriAffinity;
    private final boolean preferUri;

    ProtocolV3ObjectResolver(Connection connection, boolean preferUri) {
        this.peerNodeAffinity = new NodeAffinity(connection.getRemoteEndpointName());
        this.selfNodeAffinity = new NodeAffinity(connection.getEndpoint().getName());
        this.preferUri = preferUri;
        URI peerURI = connection.getPeerURI();
        this.peerUriAffinity = peerURI == null ? null : (URIAffinity)Affinity.forUri(peerURI);
    }

    @Override
    public Object readResolve(Object replacement) {
        if (replacement == Affinity.LOCAL) {
            return this.preferUri && this.peerUriAffinity != null ? this.peerUriAffinity : this.peerNodeAffinity;
        }
        if (replacement instanceof NodeAffinity) {
            if (replacement.equals(this.selfNodeAffinity)) {
                return Affinity.LOCAL;
            }
            if (this.preferUri && this.peerUriAffinity != null && replacement.equals(this.peerNodeAffinity)) {
                return this.peerUriAffinity;
            }
        }
        return replacement;
    }

    @Override
    public Object writeReplace(Object original) {
        if (original == Affinity.LOCAL) {
            return this.selfNodeAffinity;
        }
        if (this.peerUriAffinity != null && original instanceof URIAffinity && original.equals(this.peerUriAffinity)) {
            return this.peerNodeAffinity;
        }
        return original;
    }
}

