/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.AUTH;
import org.jgroups.util.Util;

public class DemoToken
extends AuthToken
implements AUTH.UpHandler {
    protected static final short ID = 1555;
    @Property(description="How long to wait (in ms) for a response to a challenge")
    protected long block_time = 5000L;
    protected final Map<Address, Entry> pending_requests = new HashMap<Address, Entry>();

    @Override
    public String getName() {
        return "org.jgroups.auth.DemoToken";
    }

    @Override
    public void init() {
        this.auth.register(this);
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        Address sender = msg.getSrc();
        Message challenge = new Message(sender).setFlag(Message.Flag.OOB);
        byte[] buf = DemoToken.generateRandomBytes();
        DemoHeader hdr = new DemoHeader(buf);
        challenge.putHeader((short)1555, hdr);
        Entry entry = new Entry(buf);
        this.pending_requests.put(sender, entry);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.auth.getAddress() + ": sending challenge to " + sender);
        }
        this.auth.getDownProtocol().down(new Event(1, challenge));
        try {
            boolean result;
            entry.latch.await(this.block_time, TimeUnit.MILLISECONDS);
            this.pending_requests.remove(sender);
            boolean bl = result = entry.hash > 0L && entry.hash == DemoToken.hash(DemoToken.encrypt(entry.challenge));
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.auth.getAddress() + ": authentication of " + sender + ": " + result + " (hash=" + entry.hash + ")");
            }
            return result;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                DemoHeader hdr = (DemoHeader)msg.getHeader((short)1555);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.auth.getAddress() + ": received CHALLENGE from " + msg.getSrc());
                        }
                        long hash = DemoToken.hash(DemoToken.encrypt(hdr.payload));
                        Message response = new Message(msg.getSrc()).setFlag(Message.Flag.OOB);
                        response.putHeader((short)1555, new DemoHeader(hash));
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.auth.getAddress() + ": sending RESPONSE to " + msg.getSrc());
                        }
                        this.auth.getDownProtocol().down(new Event(1, response));
                        break;
                    }
                    case 2: {
                        Entry entry;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.auth.getAddress() + ": received RESPONSE from " + msg.getSrc());
                        }
                        if ((entry = this.pending_requests.get(msg.getSrc())) == null) break;
                        entry.setResponse(hdr.hash);
                    }
                }
                return false;
            }
        }
        return true;
    }

    protected static byte[] generateRandomBytes() {
        byte[] retval = new byte[10];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (byte)Util.random(127L);
        }
        return retval;
    }

    protected static byte[] encrypt(byte[] buf) {
        return buf;
    }

    protected static long hash(byte[] buf) {
        long retval = 0L;
        for (int i = 0; i < buf.length; ++i) {
            retval += (long)buf[i];
        }
        return retval;
    }

    static {
        ClassConfigurator.add((short)1555, DemoHeader.class);
    }

    public static class DemoHeader
    extends Header {
        protected static final byte CHALLENGE = 1;
        protected static final byte RESPONSE = 2;
        protected byte type;
        protected byte[] payload;
        protected long hash;

        public DemoHeader() {
        }

        public DemoHeader(byte[] payload) {
            this.type = 1;
            this.payload = payload;
        }

        public DemoHeader(long hash) {
            this.type = (byte)2;
            this.hash = hash;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            switch (this.type) {
                case 1: {
                    Util.writeByteBuffer(this.payload, out);
                    break;
                }
                case 2: {
                    out.writeLong(this.hash);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            switch (this.type) {
                case 1: {
                    this.payload = Util.readByteBuffer(in);
                    break;
                }
                case 2: {
                    this.hash = in.readLong();
                }
            }
        }

        @Override
        public int size() {
            int retval = 1;
            switch (this.type) {
                case 1: {
                    retval += Util.size(this.payload);
                    break;
                }
                case 2: {
                    retval += 8;
                }
            }
            return retval;
        }

        @Override
        public String toString() {
            return this.type == 1 ? "CHALLENGE" : "RESPONSE, payload=" + (this.payload != null ? this.payload.length : 0) + " bytes";
        }
    }

    protected static class Entry {
        protected final CountDownLatch latch = new CountDownLatch(1);
        protected final byte[] challenge;
        protected long hash;

        public Entry(byte[] challenge) {
            this.challenge = challenge;
        }

        public void setResponse(long hash) {
            this.hash = hash;
            this.latch.countDown();
        }
    }
}

