/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.UndertowMessages;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jboss.marshalling.ByteOutput;
import org.xnio.Bits;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class WildflyClientOutputStream
extends OutputStream
implements ByteOutput {
    private ByteBuffer buffer;
    private PooledByteBuffer pooledBuffer;
    private final StreamSinkChannel channel;
    private final ByteBufferPool bufferPool;
    private int state;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_WRITE_STARTED = 2;
    private static final int MAX_BUFFERS_TO_ALLOCATE = 10;

    public WildflyClientOutputStream(StreamSinkChannel channel, ByteBufferPool byteBufferPool) {
        this.channel = channel;
        this.bufferPool = byteBufferPool;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (Thread.currentThread() == this.channel.getIoThread()) {
            throw UndertowMessages.MESSAGES.blockingIoFromIOThread();
        }
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        ByteBuffer buffer = this.buffer();
        if (buffer.remaining() < len) {
            StreamSinkChannel channel = this.channel;
            ByteBufferPool bufferPool = this.bufferPool;
            ByteBuffer[] buffers = new ByteBuffer[11];
            PooledByteBuffer[] pooledBuffers = new PooledByteBuffer[10];
            try {
                int i;
                buffers[0] = buffer;
                int bytesWritten = 0;
                int rem = buffer.remaining();
                buffer.put(b, bytesWritten + off, rem);
                buffer.flip();
                bytesWritten += rem;
                int bufferCount = 1;
                for (i = 0; i < 10; ++i) {
                    PooledByteBuffer pooled;
                    pooledBuffers[bufferCount - 1] = pooled = bufferPool.allocate();
                    buffers[bufferCount++] = pooled.getBuffer();
                    int toWrite = len - bytesWritten;
                    ByteBuffer cb = pooled.getBuffer();
                    if (toWrite > cb.remaining()) {
                        rem = cb.remaining();
                        cb.put(b, bytesWritten + off, rem);
                        cb.flip();
                        bytesWritten += rem;
                        continue;
                    }
                    cb.put(b, bytesWritten + off, len - bytesWritten);
                    bytesWritten = len;
                    cb.flip();
                    break;
                }
                Channels.writeBlocking(channel, buffers, 0, bufferCount);
                while (bytesWritten < len) {
                    bufferCount = 0;
                    for (i = 0; i < 11; ++i) {
                        ByteBuffer cb = buffers[i];
                        cb.clear();
                        ++bufferCount;
                        int toWrite = len - bytesWritten;
                        if (toWrite > cb.remaining()) {
                            rem = cb.remaining();
                            cb.put(b, bytesWritten + off, rem);
                            cb.flip();
                            bytesWritten += rem;
                            continue;
                        }
                        cb.put(b, bytesWritten + off, len - bytesWritten);
                        bytesWritten = len;
                        cb.flip();
                        break;
                    }
                    Channels.writeBlocking(channel, buffers, 0, bufferCount);
                }
                buffer.clear();
            }
            finally {
                PooledByteBuffer p;
                for (int i = 0; i < pooledBuffers.length && (p = pooledBuffers[i]) != null; ++i) {
                    p.close();
                }
            }
        } else {
            buffer.put(b, off, len);
            if (buffer.remaining() == 0) {
                this.writeBufferBlocking(false);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
    }

    private void writeBufferBlocking(boolean writeFinal) throws IOException {
        this.buffer.flip();
        while (this.buffer.hasRemaining()) {
            if (writeFinal) {
                this.channel.writeFinal(this.buffer);
            } else {
                this.channel.write(this.buffer);
            }
            if (!this.buffer.hasRemaining()) continue;
            this.channel.awaitWritable();
        }
        this.buffer.clear();
        this.state |= 2;
    }

    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return;
        }
        try {
            this.state |= 1;
            if (this.buffer != null) {
                this.writeBufferBlocking(true);
            }
            if (this.channel == null) {
                return;
            }
            StreamSinkChannel channel = this.channel;
            channel.shutdownWrites();
            Channels.flushBlocking(channel);
        }
        finally {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.close();
                this.buffer = null;
            } else {
                this.buffer = null;
            }
        }
    }

    private ByteBuffer buffer() {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            return buffer;
        }
        this.pooledBuffer = this.bufferPool.allocate();
        this.buffer = this.pooledBuffer.getBuffer();
        return this.buffer;
    }
}

