/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.NamingCloseable;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.FailedIoFuture;
import org.xnio.IoFuture;

final class SingleRemoteNamingProvider
extends RemoteNamingProvider {
    private static final AuthenticationContextConfigurationClient CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final Endpoint endpoint;
    private final Supplier<IoFuture<ConnectionPeerIdentity>> connectionFactory;
    private final NamingCloseable closeable;
    private final URI providerUri;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final SSLContext sslContext;

    SingleRemoteNamingProvider(Endpoint endpoint, URI providerUri, AuthenticationConfiguration authenticationConfiguration, SSLContext sslContext, FastHashtable<String, Object> env) {
        this.endpoint = endpoint;
        this.providerUri = providerUri;
        this.authenticationConfiguration = authenticationConfiguration;
        this.sslContext = sslContext;
        this.connectionFactory = () -> {
            SSLContext realSSLContext;
            if (sslContext == null) {
                try {
                    realSSLContext = CLIENT.getSSLContext(providerUri, AuthenticationContext.captureCurrent(), "jndi", "jboss");
                }
                catch (GeneralSecurityException e) {
                    return new FailedIoFuture(new IOException(e));
                }
            } else {
                realSSLContext = sslContext;
            }
            AuthenticationConfiguration realConf = authenticationConfiguration == null ? CLIENT.getAuthenticationConfiguration(providerUri, AuthenticationContext.captureCurrent(), -1, "jndi", "jboss") : authenticationConfiguration;
            return endpoint.getConnectedIdentity(providerUri, realSSLContext, realConf);
        };
        this.closeable = NamingCloseable.NULL;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public ConnectionPeerIdentity getPeerIdentity() throws AuthenticationException, IOException {
        return this.getFuturePeerIdentity().get();
    }

    @Override
    public IoFuture<ConnectionPeerIdentity> getFuturePeerIdentity() {
        return AccessController.doPrivileged(this.connectionFactory::get);
    }

    @Override
    public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public URI getProviderUri() {
        return this.providerUri;
    }

    @Override
    public void close() throws NamingException {
        this.closeable.close();
    }
}

