/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.ejb.EJBException;
import javax.net.ssl.SSLSession;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentIsStoppedException;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentUnavailableException;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateless.StatelessSessionComponent;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.SecurityActions;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.security.remoting.RemoteConnection;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.CancelHandle;
import org.jboss.ejb.server.ClusterTopologyListener;
import org.jboss.ejb.server.InvocationRequest;
import org.jboss.ejb.server.ListenerHandle;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.ejb.server.Request;
import org.jboss.ejb.server.SessionOpenRequest;
import org.jboss.invocation.InterceptorContext;
import org.jboss.remoting3.Connection;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.security.auth.server.SecurityIdentity;

final class AssociationImpl
implements Association,
AutoCloseable {
    private final DeploymentRepository deploymentRepository;
    private final ClusterTopologyRegistrar clusterTopologyRegistrar;
    private volatile Executor executor;

    AssociationImpl(DeploymentRepository deploymentRepository, Registry<String, List<ClientMapping>> clientMappingRegistry) {
        this.deploymentRepository = deploymentRepository;
        this.clusterTopologyRegistrar = clientMappingRegistry != null ? new ClusterTopologyRegistrar(clientMappingRegistry) : null;
    }

    @Override
    public void close() {
        if (this.clusterTopologyRegistrar != null) {
            this.clusterTopologyRegistrar.close();
        }
    }

    public CancelHandle receiveInvocationRequest(final @NotNull InvocationRequest invocationRequest) {
        boolean oneWay;
        InvocationRequest.Resolved requestContent;
        String beanName;
        String distinctName;
        String moduleName;
        EJBIdentifier ejbIdentifier = invocationRequest.getEJBIdentifier();
        String appName = ejbIdentifier.getAppName();
        EjbDeploymentInformation ejbDeploymentInformation = this.findEJB(appName, moduleName = ejbIdentifier.getModuleName(), distinctName = ejbIdentifier.getDistinctName(), beanName = ejbIdentifier.getBeanName());
        if (ejbDeploymentInformation == null) {
            invocationRequest.writeNoSuchEJB();
            return CancelHandle.NULL;
        }
        ClassLoader classLoader = ejbDeploymentInformation.getDeploymentClassLoader();
        try {
            requestContent = invocationRequest.getRequestContent(classLoader);
        }
        catch (IOException | ClassNotFoundException e) {
            invocationRequest.writeException((Exception)new EJBException(e));
            return CancelHandle.NULL;
        }
        Map attachments = requestContent.getAttachments();
        EJBLocator ejbLocator = requestContent.getEJBLocator();
        String viewClassName = ejbLocator.getViewType().getName();
        if (!ejbDeploymentInformation.isRemoteView(viewClassName)) {
            invocationRequest.writeWrongViewType();
            return CancelHandle.NULL;
        }
        ComponentView componentView = ejbDeploymentInformation.getView(viewClassName);
        Method invokedMethod = AssociationImpl.findMethod(componentView, invocationRequest.getMethodLocator());
        if (invokedMethod == null) {
            invocationRequest.writeNoSuchMethod();
            return CancelHandle.NULL;
        }
        boolean isAsync = componentView.isAsynchronous(invokedMethod);
        boolean bl = oneWay = isAsync && invokedMethod.getReturnType() == Void.TYPE;
        if (oneWay) {
            requestContent.writeInvocationResult(null);
        } else if (isAsync) {
            invocationRequest.writeProceedAsync();
        }
        CancellationFlag cancellationFlag = new CancellationFlag();
        Runnable runnable = () -> {
            Object result;
            if (!cancellationFlag.runIfNotCancelled()) {
                if (!oneWay) {
                    invocationRequest.writeCancelResponse();
                }
                return;
            }
            Connection remotingConnection = (Connection)invocationRequest.getProviderInterface(Connection.class);
            if (remotingConnection != null) {
                SecurityActions.remotingContextSetConnection(remotingConnection);
            } else {
                SecurityActions.remotingContextSetConnection(new RemoteConnection(){

                    public SSLSession getSslSession() {
                        return null;
                    }

                    public SecurityIdentity getSecurityIdentity() {
                        return invocationRequest.getSecurityIdentity();
                    }
                });
            }
            try {
                HashMap<String, Object> contextDataHolder = new HashMap<String, Object>();
                result = AssociationImpl.invokeMethod(componentView, invokedMethod, invocationRequest, requestContent, cancellationFlag, contextDataHolder);
                attachments.putAll(contextDataHolder);
            }
            catch (EJBComponentUnavailableException ex) {
                EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Cannot handle method invocation: %s on bean: %s due to EJB component unavailability exception. Returning a no such EJB available message back to client", invokedMethod, beanName);
                if (!oneWay) {
                    invocationRequest.writeNoSuchEJB();
                }
                return;
            }
            catch (ComponentIsStoppedException ex) {
                EjbLogger.EJB3_INVOCATION_LOGGER.debugf("Cannot handle method invocation: %s on bean: %s due to EJB component stopped exception. Returning a no such EJB available message back to client", invokedMethod, beanName);
                if (!oneWay) {
                    invocationRequest.writeNoSuchEJB();
                }
                return;
            }
            catch (CancellationException ex) {
                if (!oneWay) {
                    invocationRequest.writeCancelResponse();
                }
                return;
            }
            catch (Exception exception) {
                if (oneWay) {
                    return;
                }
                Throwable cause = exception.getCause();
                Object exceptionToWrite = componentView.getComponent() instanceof StatefulSessionComponent && exception instanceof EJBException && cause != null ? (!componentView.getComponent().isRemotable(cause) ? new EJBException(exception.getLocalizedMessage()) : exception) : exception;
                invocationRequest.writeException((Exception)exceptionToWrite);
                return;
            }
            finally {
                SecurityActions.remotingContextClear();
            }
            if (!oneWay) {
                try {
                    Affinity weakAffinity = null;
                    if (ejbLocator.isStateful() && componentView.getComponent() instanceof StatefulSessionComponent) {
                        StatefulSessionComponent statefulSessionComponent = (StatefulSessionComponent)componentView.getComponent();
                        weakAffinity = AssociationImpl.getWeakAffinity(statefulSessionComponent, ejbLocator.asStateful());
                    } else if (componentView.getComponent() instanceof StatelessSessionComponent) {
                        StatelessSessionComponent statelessSessionComponent = (StatelessSessionComponent)componentView.getComponent();
                        weakAffinity = statelessSessionComponent.getWeakAffinity();
                    }
                    if (weakAffinity != null && !weakAffinity.equals(Affinity.NONE)) {
                        attachments.put("jboss.ejb.weak.affinity", weakAffinity);
                    }
                    requestContent.writeInvocationResult(result);
                }
                catch (Throwable ioe) {
                    EjbLogger.REMOTE_LOGGER.couldNotWriteMethodInvocation(ioe, invokedMethod, beanName, appName, moduleName, distinctName);
                }
            }
        };
        this.execute((Request)invocationRequest, runnable, isAsync);
        return cancellationFlag::cancel;
    }

    private void execute(Request request, Runnable task, boolean isAsync) {
        if (request.getProtocol().equals("local") && !isAsync) {
            task.run();
        } else if (this.executor != null) {
            this.executor.execute(task);
        } else {
            request.getRequestExecutor().execute(task);
        }
    }

    @NotNull
    public CancelHandle receiveSessionOpenRequest(@NotNull SessionOpenRequest sessionOpenRequest) {
        EJBIdentifier ejbIdentifier = sessionOpenRequest.getEJBIdentifier();
        String appName = ejbIdentifier.getAppName();
        String moduleName = ejbIdentifier.getModuleName();
        String beanName = ejbIdentifier.getBeanName();
        String distinctName = ejbIdentifier.getDistinctName();
        EjbDeploymentInformation ejbDeploymentInformation = this.findEJB(appName, moduleName, distinctName, beanName);
        if (ejbDeploymentInformation == null) {
            sessionOpenRequest.writeNoSuchEJB();
            return CancelHandle.NULL;
        }
        EJBComponent component = ejbDeploymentInformation.getEjbComponent();
        if (!(component instanceof StatefulSessionComponent)) {
            sessionOpenRequest.writeNotStateful();
            return CancelHandle.NULL;
        }
        StatefulSessionComponent statefulSessionComponent = (StatefulSessionComponent)component;
        AtomicBoolean cancelled = new AtomicBoolean();
        Runnable runnable = () -> {
            SessionID sessionID;
            if (cancelled.get()) {
                sessionOpenRequest.writeCancelResponse();
                return;
            }
            try {
                sessionID = statefulSessionComponent.createSessionRemote();
            }
            catch (Exception t) {
                EjbLogger.REMOTE_LOGGER.exceptionGeneratingSessionId(t, statefulSessionComponent.getComponentName(), ejbIdentifier);
                sessionOpenRequest.writeException(t);
                return;
            }
            sessionOpenRequest.convertToStateful(sessionID);
        };
        this.execute((Request)sessionOpenRequest, runnable, false);
        return ignored -> cancelled.set(true);
    }

    public ListenerHandle registerClusterTopologyListener(@NotNull ClusterTopologyListener clusterTopologyListener) {
        return this.clusterTopologyRegistrar != null ? this.clusterTopologyRegistrar.registerClusterTopologyListener(clusterTopologyListener) : () -> {};
    }

    public ListenerHandle registerModuleAvailabilityListener(final @NotNull ModuleAvailabilityListener moduleAvailabilityListener) {
        DeploymentRepositoryListener listener = new DeploymentRepositoryListener(){

            @Override
            public void listenerAdded(DeploymentRepository repository) {
                moduleAvailabilityListener.moduleAvailable(repository.getModules().keySet().stream().map(AssociationImpl::toModuleIdentifier).collect(Collectors.toList()));
            }

            @Override
            public void deploymentAvailable(DeploymentModuleIdentifier deployment, ModuleDeployment moduleDeployment) {
                moduleAvailabilityListener.moduleAvailable(Collections.singletonList(AssociationImpl.toModuleIdentifier(deployment)));
            }

            @Override
            public void deploymentStarted(DeploymentModuleIdentifier deployment, ModuleDeployment moduleDeployment) {
            }

            @Override
            public void deploymentRemoved(DeploymentModuleIdentifier deployment) {
                moduleAvailabilityListener.moduleUnavailable(Collections.singletonList(AssociationImpl.toModuleIdentifier(deployment)));
            }

            @Override
            public void deploymentSuspended(DeploymentModuleIdentifier deployment) {
                moduleAvailabilityListener.moduleUnavailable(Collections.singletonList(AssociationImpl.toModuleIdentifier(deployment)));
            }

            @Override
            public void deploymentResumed(DeploymentModuleIdentifier deployment) {
                moduleAvailabilityListener.moduleAvailable(Collections.singletonList(AssociationImpl.toModuleIdentifier(deployment)));
            }
        };
        this.deploymentRepository.addListener(listener);
        return () -> this.deploymentRepository.removeListener(listener);
    }

    static EJBModuleIdentifier toModuleIdentifier(DeploymentModuleIdentifier identifier) {
        return new EJBModuleIdentifier(identifier.getApplicationName(), identifier.getModuleName(), identifier.getDistinctName());
    }

    private EjbDeploymentInformation findEJB(String appName, String moduleName, String distinctName, String beanName) {
        DeploymentModuleIdentifier ejbModule = new DeploymentModuleIdentifier(appName, moduleName, distinctName);
        Map<DeploymentModuleIdentifier, ModuleDeployment> modules = this.deploymentRepository.getStartedModules();
        if (modules == null || modules.isEmpty()) {
            return null;
        }
        ModuleDeployment moduleDeployment = modules.get(ejbModule);
        if (moduleDeployment == null) {
            return null;
        }
        return moduleDeployment.getEjbs().get(beanName);
    }

    static Object invokeMethod(ComponentView componentView, Method method, InvocationRequest incomingInvocation, InvocationRequest.Resolved content, CancellationFlag cancellationFlag, Map<String, Object> contextDataHolder) throws Exception {
        EJBLocator ejbLocator;
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setParameters(content.getParameters());
        interceptorContext.setMethod(method);
        interceptorContext.putPrivateData(Component.class, (Object)componentView.getComponent());
        interceptorContext.putPrivateData(ComponentView.class, (Object)componentView);
        interceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.REMOTE);
        interceptorContext.setBlockingCaller(false);
        HashMap invocationContextData = new HashMap();
        interceptorContext.setContextData(invocationContextData);
        if (content.getAttachments() != null) {
            for (Map.Entry attachment : content.getAttachments().entrySet()) {
                if (attachment == null) continue;
                String key = (String)attachment.getKey();
                Object value = attachment.getValue();
                if ("org.jboss.ejb.client.invocation.attachments".equals(key)) {
                    Map privateAttachments = (Map)value;
                    for (Map.Entry privateAttachment : privateAttachments.entrySet()) {
                        interceptorContext.putPrivateData(privateAttachment.getKey(), privateAttachment.getValue());
                    }
                    continue;
                }
                invocationContextData.put(key, value);
            }
        }
        if ((ejbLocator = content.getEJBLocator()).isStateful()) {
            interceptorContext.putPrivateData(SessionID.class, (Object)ejbLocator.asStateful().getSessionId());
        }
        if (content.hasTransaction()) {
            interceptorContext.setTransactionSupplier(() -> ((InvocationRequest.Resolved)content).getTransaction());
        }
        SecurityIdentity securityIdentity = incomingInvocation.getSecurityIdentity();
        boolean isAsync = componentView.isAsynchronous(method);
        boolean oneWay = isAsync && method.getReturnType() == Void.TYPE;
        boolean isSessionBean = componentView.getComponent() instanceof SessionBeanComponent;
        contextDataHolder.putAll(interceptorContext.getContextData());
        if (isAsync && isSessionBean) {
            Object result;
            if (!oneWay) {
                interceptorContext.putPrivateData(CancellationFlag.class, (Object)cancellationFlag);
            }
            return (result = AssociationImpl.invokeWithIdentity(componentView, interceptorContext, securityIdentity)) == null ? null : ((Future)result).get();
        }
        return AssociationImpl.invokeWithIdentity(componentView, interceptorContext, securityIdentity);
    }

    private static Object invokeWithIdentity(ComponentView componentView, InterceptorContext interceptorContext, SecurityIdentity securityIdentity) throws Exception {
        return securityIdentity == null ? componentView.invoke(interceptorContext) : securityIdentity.runAsFunctionEx(ComponentView::invoke, (Object)componentView, (Object)interceptorContext);
    }

    private static Method findMethod(ComponentView componentView, EJBMethodLocator ejbMethodLocator) {
        Set viewMethods = componentView.getViewMethods();
        for (Method method : viewMethods) {
            Class<?>[] methodParamTypes;
            if (!method.getName().equals(ejbMethodLocator.getMethodName()) || (methodParamTypes = method.getParameterTypes()).length != ejbMethodLocator.getParameterCount()) continue;
            boolean found = true;
            for (int i = 0; i < methodParamTypes.length; ++i) {
                if (methodParamTypes[i].getName().equals(ejbMethodLocator.getParameterTypeName(i))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return method;
        }
        return null;
    }

    private static Affinity getWeakAffinity(StatefulSessionComponent statefulSessionComponent, StatefulEJBLocator<?> statefulEJBLocator) {
        SessionID sessionID = statefulEJBLocator.getSessionId();
        return statefulSessionComponent.getCache().getWeakAffinity(sessionID);
    }

    Executor getExecutor() {
        return this.executor;
    }

    void setExecutor(Executor executor) {
        this.executor = executor;
    }

    private class ClusterTopologyRegistrar
    implements Registry.Listener<String, List<ClientMapping>> {
        private final Set<ClusterTopologyListener> clusterTopologyListeners = ConcurrentHashMap.newKeySet();
        private final Registry<String, List<ClientMapping>> clientMappingRegistry;

        ClusterTopologyRegistrar(Registry<String, List<ClientMapping>> clientMappingRegistry) {
            this.clientMappingRegistry = clientMappingRegistry;
            this.clientMappingRegistry.addListener((Registry.Listener)this);
        }

        public void addedEntries(Map<String, List<ClientMapping>> added) {
            ClusterTopologyListener.ClusterInfo info = this.getClusterInfo(added);
            this.clusterTopologyListeners.forEach(listener -> {
                ClusterTopologyListener clusterTopologyListener = listener;
                synchronized (clusterTopologyListener) {
                    listener.clusterNewNodesAdded(info);
                }
            });
        }

        public void updatedEntries(Map<String, List<ClientMapping>> updated) {
            this.addedEntries(updated);
        }

        public void removedEntries(Map<String, List<ClientMapping>> removed) {
            List<ClusterTopologyListener.ClusterRemovalInfo> removals = Collections.singletonList(new ClusterTopologyListener.ClusterRemovalInfo(this.clientMappingRegistry.getGroup().getName(), new ArrayList<String>(removed.keySet())));
            this.clusterTopologyListeners.forEach(listener -> {
                ClusterTopologyListener clusterTopologyListener = listener;
                synchronized (clusterTopologyListener) {
                    listener.clusterNodesRemoved(removals);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ListenerHandle registerClusterTopologyListener(ClusterTopologyListener listener) {
            ClusterTopologyListener clusterTopologyListener = listener;
            synchronized (clusterTopologyListener) {
                this.clusterTopologyListeners.add(listener);
                listener.clusterTopology(Collections.singletonList(this.getClusterInfo(this.clientMappingRegistry.getEntries())));
            }
            return () -> this.clusterTopologyListeners.remove(listener);
        }

        void close() {
            this.clientMappingRegistry.removeListener((Registry.Listener)this);
            this.clusterTopologyListeners.clear();
        }

        private ClusterTopologyListener.ClusterInfo getClusterInfo(Map<String, List<ClientMapping>> entries) {
            ArrayList<ClusterTopologyListener.NodeInfo> nodeInfoList = new ArrayList<ClusterTopologyListener.NodeInfo>(entries.size());
            for (Map.Entry<String, List<ClientMapping>> entry : entries.entrySet()) {
                String nodeName = entry.getKey();
                List<ClientMapping> clientMappingList = entry.getValue();
                ArrayList<ClusterTopologyListener.MappingInfo> mappingInfoList = new ArrayList<ClusterTopologyListener.MappingInfo>(clientMappingList.size());
                for (ClientMapping clientMapping : clientMappingList) {
                    mappingInfoList.add(new ClusterTopologyListener.MappingInfo(clientMapping.getDestinationAddress(), clientMapping.getDestinationPort(), clientMapping.getSourceNetworkAddress(), clientMapping.getSourceNetworkMaskBits()));
                }
                nodeInfoList.add(new ClusterTopologyListener.NodeInfo(nodeName, mappingInfoList));
            }
            return new ClusterTopologyListener.ClusterInfo(this.clientMappingRegistry.getGroup().getName(), nodeInfoList);
        }
    }
}

