/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.protocol;

import java.io.IOException;
import org.apache.maven.wagon.providers.http.httpclient.HttpEntity;
import org.apache.maven.wagon.providers.http.httpclient.HttpEntityEnclosingRequest;
import org.apache.maven.wagon.providers.http.httpclient.HttpException;
import org.apache.maven.wagon.providers.http.httpclient.HttpRequest;
import org.apache.maven.wagon.providers.http.httpclient.HttpRequestInterceptor;
import org.apache.maven.wagon.providers.http.httpclient.HttpVersion;
import org.apache.maven.wagon.providers.http.httpclient.ProtocolVersion;
import org.apache.maven.wagon.providers.http.httpclient.annotation.Immutable;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;
import org.apache.maven.wagon.providers.http.httpclient.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

