/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.IOException;
import org.apache.commons.cli.MissingArgumentException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ELYTOOL", length=5)
public interface ElytronToolMessages
extends BasicLogger {
    public static final ElytronToolMessages msg = Logger.getMessageLogger(ElytronToolMessages.class, "org.wildfly.security.tool");

    @Message(id=0, value="Command or alias \"%s\" not found.")
    public String commandOrAliasNotFound(String var1);

    @Message(id=0, value="Input data not confirmed. Exiting.")
    public String inputDataNotConfirmed();

    @Message(id=0, value="%s %s")
    public String cmdHelp(String var1, String var2);

    @Message(id=0, value="Exception encountered executing the command:")
    public String commandExecuteException();

    @Message(id=0, value="Printing general help message:")
    public String generalHelpTitle();

    @Message(id=0, value="Location of credential store storage file")
    public String cmdLineStoreLocationDesc();

    @Message(id=0, value="\"credential-store\" command is used to perform various operations on credential store.")
    public String cmdLineCredentialStoreHelpHeader();

    @Message(id=0, value="Implementation properties for credential store type in form of \"prop1=value1; ... ;propN=valueN\" .%nSupported properties are dependent on credential store type%nKeyStoreCredentialStore (default implementation) supports following additional properties (all are optional):%nkeyStoreType - specifies the key store type to use (defaults to \"JCEKS\")%nkeyAlias - specifies the secret key alias within the key store to use for encrypt/decrypt of data in external storage (defaults to \"cs_key\")%nexternal - specifies whether to store data to external storage and encrypted by keyAlias key (defaults to \"false\")%ncryptoAlg - cryptographic algorithm name to be used to encrypt/decrypt entries at external storage \"external\" has to be set to \"true\"")
    public String cmdLineImplementationPropertiesDesc();

    @Message(id=0, value="Password for credential store")
    public String cmdLineCredentialStorePassword();

    @Message(id=0, value="Salt to apply for final masked password of the credential store")
    public String cmdLineSaltDesc();

    @Message(id=0, value="Iteration count for final masked password of the credential store")
    public String cmdLineIterationCountDesc();

    @Message(id=0, value="Password credential value")
    public String cmdLinePasswordCredentialValueDesc();

    @Message(id=0, value="Type of entry in credential store")
    public String cmdLineEntryTypeDesc();

    @Message(id=0, value="Comma separated list of JCA provider names. Providers will be supplied to the credential store instance.%nEach provider must be installed through java.security file or through service loader from properly packaged jar file on classpath.")
    public String cmdLineOtherProvidersDesc();

    @Message(id=0, value="Provider name containing CredentialStoreSpi implementation.%nProvider must be installed through java.security file or through service loader from properly packaged jar file on classpath.")
    public String cmdLineCustomCredentialStoreProviderDesc();

    @Message(id=0, value="Create credential store")
    public String cmdLineCreateCredentialStoreDesc();

    @Message(id=0, value="Credential store type")
    public String cmdLineCredentialStoreTypeDesc();

    @Message(id=0, value="Add new alias to the credential store")
    public String cmdLineAddAliasDesc();

    @Message(id=0, value="Remove alias from the credential store")
    public String cmdLineRemoveAliasDesc();

    @Message(id=0, value="Check if alias exists within the credential store")
    public String cmdLineCheckAliasDesc();

    @Message(id=0, value="Display all aliases")
    public String cmdLineAliasesDesc();

    @Message(id=0, value="Print summary, especially command how to create this credential store")
    public String cmdLinePrintSummary();

    @Message(id=0, value="Get help with usage of this command")
    public String cmdLineHelp();

    @Message(id=0, value="Alias \"%s\" exists")
    public String aliasExists(String var1);

    @Message(id=0, value="Alias \"%s\" does not exist")
    public String aliasDoesNotExist(String var1);

    @Message(id=0, value="Alias \"%s\" of type \"%s\"does not exist")
    public String aliasDoesNotExist(String var1, String var2);

    @Message(id=0, value="Alias \"%s\" has been successfully stored")
    public String aliasStored(String var1);

    @Message(id=0, value="Alias \"%s\" of type \"%s\" has been successfully stored")
    public String aliasStored(String var1, String var2);

    @Message(id=0, value="Alias \"%s\" has been successfully removed")
    public String aliasRemoved(String var1);

    @Message(id=0, value="Alias \"%s\" of type \"%s\" has been successfully removed")
    public String aliasRemoved(String var1, String var2);

    @Message(id=0, value="Credential store command summary:%n--------------------------------------%n%s")
    public String commandSummary(String var1);

    @Message(id=0, value="Credential store contains following aliases: %s")
    public String aliases(String var1);

    @Message(id=0, value="Credential store contains no aliases")
    public String noAliases();

    @Message(id=0, value="Action to perform on the credential store is not defined")
    public Exception actionToPerformNotDefined();

    @Message(id=0, value="Credential store password: ")
    public String credentialStorePasswordPrompt();

    @Message(id=0, value="Confirm credential store password: ")
    public String credentialStorePasswordPromptConfirm();

    @Message(id=0, value="Secret to store: ")
    public String secretToStorePrompt();

    @Message(id=0, value="Confirm secret to store: ")
    public String secretToStorePromptConfirm();

    @Message(id=0, value="\"mask\" command is used to get MASK- string encrypted using PBEWithMD5AndDES in PicketBox compatible way.")
    public String cmdMaskHelpHeader();

    @Message(id=0, value="Salt to apply to masked string")
    public String cmdMaskSaltDesc();

    @Message(id=0, value="Iteration count for masked string")
    public String cmdMaskIterationCountDesc();

    @Message(id=0, value="Secret to be encrypted")
    public String cmdMaskSecretDesc();

    @Message(id=6, value="Salt not specified.")
    public MissingArgumentException saltNotSpecified();

    @Message(id=7, value="Invalid \"%s\" value. Must be an integer between %d and %d, inclusive")
    public IllegalArgumentException invalidParameterMustBeIntBetween(String var1, int var2, int var3);

    @Message(id=0, value="\"vault\" command is used convert PicketBox Security Vault to credential store using default implementation (KeyStoreCredentialStore).")
    public String cmdVaultHelpHeader();

    @Message(id=0, value="Vault keystore URL (defaults to \"vault.keystore\")")
    public String cmdLineVaultKeyStoreURL();

    @Message(id=0, value="Vault keystore password:%n- used to open original vault key store%n- used as password for new converted credential store")
    public String cmdLineVaultKeyStorePassword();

    @Message(id=0, value="Vault directory containing encrypted files (defaults to \"vault\")")
    public String cmdLineVaultEncryptionDirectory();

    @Message(id=0, value="8 character salt (defaults to \"12345678\")")
    public String cmdVaultLineSalt();

    @Message(id=0, value="Iteration count (defaults to \"23\")")
    public String cmdLineVaultIterationCount();

    @Message(id=0, value="Vault master key alias within key store (defaults to \"vault\")")
    public String cmdLineVaultKeyStoreAlias();

    @Message(id=0, value="Configuration parameters for credential store in form of: \"parameter1=value1; ... ;parameterN=valueN\"%nSupported parameters are dependent on credential store type%nGenerally supported parameters for default credential store implementation (all are optional):%ncreate - automatically creates credential store file (true/false)%nmodifiable - is the credential modifiable (true/false)%nlocation - file location of credential store%nkeyStoreType - specify the key store type to use")
    public String cmdLineVaultCSParametersDesc();

    @Message(id=0, value="Vault Conversion summary:%n--------------------------------------%n%s%n--------------------------------------%n")
    public String vaultConversionSummary(String var1);

    @Message(id=0, value="Vault Conversion Successful%n")
    public String conversionSuccessful();

    @Message(id=0, value="CLI command to add new credential store:%n")
    public String cliCommandToNewCredentialStore();

    @Message(id=0, value="Bulk conversion with options listed in description file. All options have no default value and should be set in the file.%nAll options are required with two exceptions:%n - \"properties\" option%n - \"salt\" and \"iteration\" options can be omitted when plain-text password is used%nEach set of options must start with the \"keystore\" option in the following format:%n keystore:<value>%nkeystore-password:<value>%nenc-dir:<value>%nsalt:<value>%niteration:<value>%nlocation:<value>%nalias:<value>%nproperties:<parameter1>=<value1>; ... ;<parameterN>=<valueN>")
    public String cliCommandBulkVaultCredentialStoreConversion();

    @Message(id=0, value="Print summary of conversion")
    public String cmdLineVaultPrintSummary();

    @Message(id=0, value="Location of credential store storage file (defaults to \"converted-vault.cr-store\" in vault encryption directory)")
    public String cmdLineVaultCSLocationDesc();

    @Message(id=8, value="Cannot locate admin key with alias \"%s\" or it is of improper type")
    public RuntimeException cannotLocateAdminKey(String var1);

    @Message(id=9, value="Cannot parse credential store implementation properties from supplied parameter")
    public RuntimeException cannotParseProps();

    @Message(id=0, value="Vault (enc-dir=\"%s\";keystore=\"%s\") converted to credential store \"%s\"")
    public String vaultConvertedToCS(String var1, String var2, String var3);

    @Message(id=10, value="Cannot parse conversion descriptor file \"%s\" missing colon at line %s")
    public IOException descriptorParseMissingColon(String var1, String var2);

    @Message(id=11, value="Unrecognized descriptor attribute at line %s")
    public IOException unrecognizedDescriptorAttribute(String var1);

    @Message(id=12, value="Problem converting vault (enc-dir=\"%s\";keystore=\"%s\")")
    public Exception bulkConversionProblem(String var1, String var2, @Cause Throwable var3);

    @Message(id=13, value="Invalid option \"%s\" when performing bulk conversion. Use bulk conversion descriptor file.")
    public Exception bulkConversionInvalidOption(String var1);

    @Message(id=14, value="Unknown entry-type \"%s\"")
    public IllegalArgumentException unknownEntryType(String var1);

    @Message(id=15, value="Unknown provider \"%s\"")
    public IllegalArgumentException unknownProvider(String var1);

    @Message(id=0, value="Credential Store has been successfully created")
    public String credentialStoreCreated();

    @Message(id=16, value="Option \"%s\" is not specified.")
    public MissingArgumentException optionNotSpecified(String var1);

    @Message(id=17, value="Option \"%s\" specified more than once. Only the first occurrence will be used.")
    public String duplicateOptionSpecified(String var1);

    @Message(id=18, value="Option \"%s\" does not expect any arguments.")
    public MissingArgumentException noArgumentOption(String var1);

    @Message(id=0, value="Vault password: ")
    public String vaultPasswordPrompt();

    @Message(id=0, value="Confirm vault password: ")
    public String vaultPasswordPromptConfirm();

    @Message(id=19, value="Encryption directory \"%s\" does not contain \"VAULT.dat\" file.")
    public IllegalArgumentException vaultFileNotFound(String var1);

    @Message(id=0, value="Mask secret: ")
    public String maskSecretPrompt();

    @Message(id=0, value="Confirm mask secret: ")
    public String maskSecretPromptConfirm();

    @Message(id=0, value="Print stack trace when error occurs.")
    public String cmdLineDebug();

    @Message(id=0, value="Exception encountered executing the command. Use option \"--debug\" for complete exception stack trace.")
    public String commandExecuteExceptionNoDebug();

    @Message(id=20, value="Alias was not defined.")
    public MissingArgumentException undefinedAlias();

    @Message(id=21, value="Location of the output file was not defined.")
    public MissingArgumentException undefinedOutputLocation();

    @Message(id=22, value="Encryption directory was not defined.")
    public MissingArgumentException undefinedEncryptionDirectory();

    @Message(id=23, value="Vault password was not defined")
    public MissingArgumentException undefinedVaultPassword();

    @Message(id=24, value="Cannot parse conversion descriptor file \"%s\". No keystore specified.")
    public IOException undefinedKeystore(String var1);

    @Message(id=25, value="Credential store storage file \"%s\" does not exist.")
    public IllegalArgumentException storageFileDoesNotExist(String var1);

    @Message(id=26, value="Credential store storage file \"%s\" already exists.")
    public IllegalArgumentException storageFileExists(String var1);

    @Message(id=27, value="Wrong masked password format. Expected format is \"MASK-<encoded payload>;<salt>;<iteration>\"")
    public IllegalArgumentException wrongMaskedPasswordFormat();
}

