/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.ASN1Decoder;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;

public abstract class AbstractAlgorithmParametersSpiImpl<P extends AlgorithmParameterSpec>
extends AlgorithmParametersSpi {
    private P parameterSpec;
    private byte[] encoded;

    protected AbstractAlgorithmParametersSpiImpl() {
    }

    protected abstract Class<P> getParameterType();

    @Override
    protected final void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        Class<P> parameterType = this.getParameterType();
        if (parameterType.isInstance(paramSpec)) {
            try {
                ByteStringBuilder b = new ByteStringBuilder();
                DEREncoder encoder = new DEREncoder(b);
                AlgorithmParameterSpec cast = (AlgorithmParameterSpec)parameterType.cast(paramSpec);
                this.engineEncode(encoder, cast);
                this.encoded = b.toArray();
                this.parameterSpec = cast;
            }
            catch (ASN1Exception e) {
                throw ElytronMessages.log.failedToEncode(e);
            }
        } else {
            throw ElytronMessages.log.invalidParameterSpec(parameterType, paramSpec.getClass());
        }
    }

    @Override
    protected final void engineInit(byte[] params) throws IOException {
        ByteIterator bi = ByteIterator.ofBytes(params);
        DERDecoder decoder = new DERDecoder(bi);
        try {
            this.parameterSpec = this.engineDecode(decoder);
            this.encoded = params;
        }
        catch (ASN1Exception e) {
            throw ElytronMessages.log.failedToDecode(e);
        }
    }

    @Override
    protected final void engineInit(byte[] params, String format) throws IOException {
        if (!"ASN.1".equalsIgnoreCase(format)) {
            throw ElytronMessages.log.invalidFormat("ASN.1", format);
        }
        this.engineInit(params);
    }

    protected abstract void engineEncode(ASN1Encoder var1, P var2) throws ASN1Exception, InvalidParameterSpecException;

    protected abstract P engineDecode(ASN1Decoder var1) throws ASN1Exception, IOException;

    @Override
    protected final <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> type) throws InvalidParameterSpecException {
        this.checkInit();
        if (type.isAssignableFrom(this.getParameterType()) && type.isInstance(this.parameterSpec)) {
            return (T)((AlgorithmParameterSpec)type.cast(this.parameterSpec));
        }
        throw ElytronMessages.log.invalidParameterSpec(this.getParameterType(), type);
    }

    @Override
    protected final byte[] engineGetEncoded() {
        this.checkInit();
        return this.encoded;
    }

    @Override
    protected final byte[] engineGetEncoded(String format) throws IOException {
        this.checkInit();
        if ("ASN.1".equalsIgnoreCase(format)) {
            return this.engineGetEncoded();
        }
        throw ElytronMessages.log.invalidFormat("ASN.1", format);
    }

    private void checkInit() {
        if (this.parameterSpec == null || this.encoded == null) {
            throw ElytronMessages.log.algorithmParametersNotInitialized();
        }
    }

    @Override
    protected String engineToString() {
        return "AlgorithmParametersSpi for " + this.getParameterType();
    }
}

