/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.net.URL;
import java.util.Arrays;
import javax.resource.spi.ResourceAdapter;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.deployers.DeployersLogger;

public class CommonDeployment {
    private final URL url;
    private final String deploymentName;
    private final boolean activateDeployment;
    private final ResourceAdapter resourceAdapter;
    private final String resourceAdapterKey;
    private final String bootstrapContextIdentifier;
    private final Object[] cfs;
    private final String[] cfJndiNames;
    private final ConnectionManager[] cfCMs;
    private final Object[] aos;
    private final String[] aoJndiNames;
    private final XAResourceRecovery[] recoveryModules;
    private final Connector connector;
    private final DataSource[] dataSources;
    private final ClassLoader cl;
    private final DeployersLogger log;

    public CommonDeployment(URL url, String deploymentName, boolean activateDeployment, ResourceAdapter resourceAdapter, String resourceAdapterKey, String bootstrapContextIdentifier, Object[] cfs, String[] cfJndiNames, ConnectionManager[] cfCM, Object[] aos, String[] aoJndiNames, XAResourceRecovery[] recoveryModules, Connector connector, DataSource[] dataSources, ClassLoader cl, DeployersLogger log) {
        this.url = url;
        this.deploymentName = deploymentName;
        this.activateDeployment = activateDeployment;
        this.resourceAdapter = resourceAdapter;
        this.resourceAdapterKey = resourceAdapterKey;
        this.bootstrapContextIdentifier = bootstrapContextIdentifier;
        this.cfs = cfs != null ? Arrays.copyOf(cfs, cfs.length) : null;
        this.cfJndiNames = cfJndiNames != null ? Arrays.copyOf(cfJndiNames, cfJndiNames.length) : null;
        this.cfCMs = cfCM != null ? Arrays.copyOf(cfCM, cfCM.length) : null;
        this.aos = aos != null ? Arrays.copyOf(aos, aos.length) : null;
        this.aoJndiNames = aoJndiNames != null ? Arrays.copyOf(aoJndiNames, aoJndiNames.length) : null;
        this.recoveryModules = recoveryModules;
        this.connector = connector;
        this.dataSources = dataSources;
        this.cl = cl;
        this.log = log;
    }

    public final URL getURL() {
        return this.url;
    }

    public final String getDeploymentName() {
        return this.deploymentName;
    }

    public final boolean isActivateDeployment() {
        return this.activateDeployment;
    }

    public final ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public final String getResourceAdapterKey() {
        return this.resourceAdapterKey;
    }

    public final String getBootstrapContextIdentifier() {
        return this.bootstrapContextIdentifier;
    }

    public final Object[] getCfs() {
        return this.cfs != null ? Arrays.copyOf(this.cfs, this.cfs.length) : null;
    }

    public final String[] getCfJndiNames() {
        return this.cfJndiNames != null ? Arrays.copyOf(this.cfJndiNames, this.cfJndiNames.length) : null;
    }

    public final ConnectionManager[] getConnectionManagers() {
        return this.cfCMs != null ? Arrays.copyOf(this.cfCMs, this.cfCMs.length) : null;
    }

    public final Object[] getAos() {
        return this.aos != null ? Arrays.copyOf(this.aos, this.aos.length) : null;
    }

    public final String[] getAoJndiNames() {
        return this.aoJndiNames != null ? Arrays.copyOf(this.aoJndiNames, this.aoJndiNames.length) : null;
    }

    public final XAResourceRecovery[] getRecovery() {
        return this.recoveryModules;
    }

    public final Connector getConnector() {
        return this.connector;
    }

    public final DataSource[] getDataSources() {
        return this.dataSources;
    }

    public final ClassLoader getCl() {
        return this.cl;
    }

    public final DeployersLogger getLog() {
        return this.log;
    }
}

